/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.MapOfMessageResultCopier;
import software.amazon.awssdk.services.pinpoint.model.MessageResult;
import software.amazon.awssdk.services.pinpoint.transform.MessageResponseMarshaller;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MessageResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, MessageResponse> {
    private final String applicationId;
    private final String requestId;
    private final Map<String, MessageResult> result;

    private MessageResponse(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.requestId = builder.requestId;
        this.result = builder.result;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String requestId() {
        return this.requestId;
    }

    public Map<String, MessageResult> result() {
        return this.result;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationId() == null ? 0 : this.applicationId().hashCode());
        hashCode = 31 * hashCode + (this.requestId() == null ? 0 : this.requestId().hashCode());
        hashCode = 31 * hashCode + (this.result() == null ? 0 : this.result().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageResponse)) {
            return false;
        }
        MessageResponse other = (MessageResponse)obj;
        if (other.applicationId() == null ^ this.applicationId() == null) {
            return false;
        }
        if (other.applicationId() != null && !other.applicationId().equals(this.applicationId())) {
            return false;
        }
        if (other.requestId() == null ^ this.requestId() == null) {
            return false;
        }
        if (other.requestId() != null && !other.requestId().equals(this.requestId())) {
            return false;
        }
        if (other.result() == null ^ this.result() == null) {
            return false;
        }
        return other.result() == null || other.result().equals(this.result());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.requestId() != null) {
            sb.append("RequestId: ").append(this.requestId()).append(",");
        }
        if (this.result() != null) {
            sb.append("Result: ").append(this.result()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "RequestId": {
                return Optional.of(clazz.cast(this.requestId()));
            }
            case "Result": {
                return Optional.of(clazz.cast(this.result()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MessageResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String requestId;
        private Map<String, MessageResult> result;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageResponse model) {
            this.applicationId(model.applicationId);
            this.requestId(model.requestId);
            this.result(model.result);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final Map<String, MessageResult.Builder> getResult() {
            return this.result != null ? CollectionUtils.mapValues(this.result, MessageResult::toBuilder) : null;
        }

        @Override
        public final Builder result(Map<String, MessageResult> result) {
            this.result = MapOfMessageResultCopier.copy(result);
            return this;
        }

        public final void setResult(Map<String, MessageResult.BuilderImpl> result) {
            this.result = MapOfMessageResultCopier.copyFromBuilder(result);
        }

        public MessageResponse build() {
            return new MessageResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MessageResponse> {
        public Builder applicationId(String var1);

        public Builder requestId(String var1);

        public Builder result(Map<String, MessageResult> var1);
    }
}

