/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.APNSMessage;
import software.amazon.awssdk.services.pinpoint.model.DefaultMessage;
import software.amazon.awssdk.services.pinpoint.model.DefaultPushNotificationMessage;
import software.amazon.awssdk.services.pinpoint.model.GCMMessage;
import software.amazon.awssdk.services.pinpoint.model.SMSMessage;
import software.amazon.awssdk.services.pinpoint.transform.DirectMessageConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DirectMessageConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, DirectMessageConfiguration> {
    private final APNSMessage apnsMessage;
    private final DefaultMessage defaultMessage;
    private final DefaultPushNotificationMessage defaultPushNotificationMessage;
    private final GCMMessage gcmMessage;
    private final SMSMessage smsMessage;

    private DirectMessageConfiguration(BuilderImpl builder) {
        this.apnsMessage = builder.apnsMessage;
        this.defaultMessage = builder.defaultMessage;
        this.defaultPushNotificationMessage = builder.defaultPushNotificationMessage;
        this.gcmMessage = builder.gcmMessage;
        this.smsMessage = builder.smsMessage;
    }

    public APNSMessage apnsMessage() {
        return this.apnsMessage;
    }

    public DefaultMessage defaultMessage() {
        return this.defaultMessage;
    }

    public DefaultPushNotificationMessage defaultPushNotificationMessage() {
        return this.defaultPushNotificationMessage;
    }

    public GCMMessage gcmMessage() {
        return this.gcmMessage;
    }

    public SMSMessage smsMessage() {
        return this.smsMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.apnsMessage() == null ? 0 : this.apnsMessage().hashCode());
        hashCode = 31 * hashCode + (this.defaultMessage() == null ? 0 : this.defaultMessage().hashCode());
        hashCode = 31 * hashCode + (this.defaultPushNotificationMessage() == null ? 0 : this.defaultPushNotificationMessage().hashCode());
        hashCode = 31 * hashCode + (this.gcmMessage() == null ? 0 : this.gcmMessage().hashCode());
        hashCode = 31 * hashCode + (this.smsMessage() == null ? 0 : this.smsMessage().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectMessageConfiguration)) {
            return false;
        }
        DirectMessageConfiguration other = (DirectMessageConfiguration)obj;
        if (other.apnsMessage() == null ^ this.apnsMessage() == null) {
            return false;
        }
        if (other.apnsMessage() != null && !other.apnsMessage().equals(this.apnsMessage())) {
            return false;
        }
        if (other.defaultMessage() == null ^ this.defaultMessage() == null) {
            return false;
        }
        if (other.defaultMessage() != null && !other.defaultMessage().equals(this.defaultMessage())) {
            return false;
        }
        if (other.defaultPushNotificationMessage() == null ^ this.defaultPushNotificationMessage() == null) {
            return false;
        }
        if (other.defaultPushNotificationMessage() != null && !other.defaultPushNotificationMessage().equals(this.defaultPushNotificationMessage())) {
            return false;
        }
        if (other.gcmMessage() == null ^ this.gcmMessage() == null) {
            return false;
        }
        if (other.gcmMessage() != null && !other.gcmMessage().equals(this.gcmMessage())) {
            return false;
        }
        if (other.smsMessage() == null ^ this.smsMessage() == null) {
            return false;
        }
        return other.smsMessage() == null || other.smsMessage().equals(this.smsMessage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.apnsMessage() != null) {
            sb.append("APNSMessage: ").append(this.apnsMessage()).append(",");
        }
        if (this.defaultMessage() != null) {
            sb.append("DefaultMessage: ").append(this.defaultMessage()).append(",");
        }
        if (this.defaultPushNotificationMessage() != null) {
            sb.append("DefaultPushNotificationMessage: ").append(this.defaultPushNotificationMessage()).append(",");
        }
        if (this.gcmMessage() != null) {
            sb.append("GCMMessage: ").append(this.gcmMessage()).append(",");
        }
        if (this.smsMessage() != null) {
            sb.append("SMSMessage: ").append(this.smsMessage()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "APNSMessage": {
                return Optional.of(clazz.cast(this.apnsMessage()));
            }
            case "DefaultMessage": {
                return Optional.of(clazz.cast(this.defaultMessage()));
            }
            case "DefaultPushNotificationMessage": {
                return Optional.of(clazz.cast(this.defaultPushNotificationMessage()));
            }
            case "GCMMessage": {
                return Optional.of(clazz.cast(this.gcmMessage()));
            }
            case "SMSMessage": {
                return Optional.of(clazz.cast(this.smsMessage()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DirectMessageConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private APNSMessage apnsMessage;
        private DefaultMessage defaultMessage;
        private DefaultPushNotificationMessage defaultPushNotificationMessage;
        private GCMMessage gcmMessage;
        private SMSMessage smsMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DirectMessageConfiguration model) {
            this.apnsMessage(model.apnsMessage);
            this.defaultMessage(model.defaultMessage);
            this.defaultPushNotificationMessage(model.defaultPushNotificationMessage);
            this.gcmMessage(model.gcmMessage);
            this.smsMessage(model.smsMessage);
        }

        public final APNSMessage.Builder getAPNSMessage() {
            return this.apnsMessage != null ? this.apnsMessage.toBuilder() : null;
        }

        @Override
        public final Builder apnsMessage(APNSMessage apnsMessage) {
            this.apnsMessage = apnsMessage;
            return this;
        }

        public final void setAPNSMessage(APNSMessage.BuilderImpl apnsMessage) {
            this.apnsMessage = apnsMessage != null ? apnsMessage.build() : null;
        }

        public final DefaultMessage.Builder getDefaultMessage() {
            return this.defaultMessage != null ? this.defaultMessage.toBuilder() : null;
        }

        @Override
        public final Builder defaultMessage(DefaultMessage defaultMessage) {
            this.defaultMessage = defaultMessage;
            return this;
        }

        public final void setDefaultMessage(DefaultMessage.BuilderImpl defaultMessage) {
            this.defaultMessage = defaultMessage != null ? defaultMessage.build() : null;
        }

        public final DefaultPushNotificationMessage.Builder getDefaultPushNotificationMessage() {
            return this.defaultPushNotificationMessage != null ? this.defaultPushNotificationMessage.toBuilder() : null;
        }

        @Override
        public final Builder defaultPushNotificationMessage(DefaultPushNotificationMessage defaultPushNotificationMessage) {
            this.defaultPushNotificationMessage = defaultPushNotificationMessage;
            return this;
        }

        public final void setDefaultPushNotificationMessage(DefaultPushNotificationMessage.BuilderImpl defaultPushNotificationMessage) {
            this.defaultPushNotificationMessage = defaultPushNotificationMessage != null ? defaultPushNotificationMessage.build() : null;
        }

        public final GCMMessage.Builder getGCMMessage() {
            return this.gcmMessage != null ? this.gcmMessage.toBuilder() : null;
        }

        @Override
        public final Builder gcmMessage(GCMMessage gcmMessage) {
            this.gcmMessage = gcmMessage;
            return this;
        }

        public final void setGCMMessage(GCMMessage.BuilderImpl gcmMessage) {
            this.gcmMessage = gcmMessage != null ? gcmMessage.build() : null;
        }

        public final SMSMessage.Builder getSMSMessage() {
            return this.smsMessage != null ? this.smsMessage.toBuilder() : null;
        }

        @Override
        public final Builder smsMessage(SMSMessage smsMessage) {
            this.smsMessage = smsMessage;
            return this;
        }

        public final void setSMSMessage(SMSMessage.BuilderImpl smsMessage) {
            this.smsMessage = smsMessage != null ? smsMessage.build() : null;
        }

        public DirectMessageConfiguration build() {
            return new DirectMessageConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DirectMessageConfiguration> {
        public Builder apnsMessage(APNSMessage var1);

        public Builder defaultMessage(DefaultMessage var1);

        public Builder defaultPushNotificationMessage(DefaultPushNotificationMessage var1);

        public Builder gcmMessage(GCMMessage var1);

        public Builder smsMessage(SMSMessage var1);
    }
}

