/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.transform.APNSChannelRequestMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class APNSChannelRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, APNSChannelRequest> {
    private final String certificate;
    private final Boolean enabled;
    private final String privateKey;

    private APNSChannelRequest(BuilderImpl builder) {
        this.certificate = builder.certificate;
        this.enabled = builder.enabled;
        this.privateKey = builder.privateKey;
    }

    public String certificate() {
        return this.certificate;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public String privateKey() {
        return this.privateKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.certificate() == null ? 0 : this.certificate().hashCode());
        hashCode = 31 * hashCode + (this.enabled() == null ? 0 : this.enabled().hashCode());
        hashCode = 31 * hashCode + (this.privateKey() == null ? 0 : this.privateKey().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof APNSChannelRequest)) {
            return false;
        }
        APNSChannelRequest other = (APNSChannelRequest)obj;
        if (other.certificate() == null ^ this.certificate() == null) {
            return false;
        }
        if (other.certificate() != null && !other.certificate().equals(this.certificate())) {
            return false;
        }
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.privateKey() == null ^ this.privateKey() == null) {
            return false;
        }
        return other.privateKey() == null || other.privateKey().equals(this.privateKey());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.certificate() != null) {
            sb.append("Certificate: ").append(this.certificate()).append(",");
        }
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.privateKey() != null) {
            sb.append("PrivateKey: ").append(this.privateKey()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Certificate": {
                return Optional.of(clazz.cast(this.certificate()));
            }
            case "Enabled": {
                return Optional.of(clazz.cast(this.enabled()));
            }
            case "PrivateKey": {
                return Optional.of(clazz.cast(this.privateKey()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        APNSChannelRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificate;
        private Boolean enabled;
        private String privateKey;

        private BuilderImpl() {
        }

        private BuilderImpl(APNSChannelRequest model) {
            this.certificate(model.certificate);
            this.enabled(model.enabled);
            this.privateKey(model.privateKey);
        }

        public final String getCertificate() {
            return this.certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getPrivateKey() {
            return this.privateKey;
        }

        @Override
        public final Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public final void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public APNSChannelRequest build() {
            return new APNSChannelRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, APNSChannelRequest> {
        public Builder certificate(String var1);

        public Builder enabled(Boolean var1);

        public Builder privateKey(String var1);
    }
}

