/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pinpoint.model.SegmentDimensions;
import software.amazon.awssdk.services.pinpoint.transform.AttributeDimensionUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.SegmentBehaviorsUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.SegmentDemographicsUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.SegmentLocationUnmarshaller;

public class SegmentDimensionsUnmarshaller
implements Unmarshaller<SegmentDimensions, JsonUnmarshallerContext> {
    private static final SegmentDimensionsUnmarshaller INSTANCE = new SegmentDimensionsUnmarshaller();

    public SegmentDimensions unmarshall(JsonUnmarshallerContext context) throws Exception {
        SegmentDimensions.Builder segmentDimensionsBuilder = SegmentDimensions.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Attributes", targetDepth)) {
                    context.nextToken();
                    segmentDimensionsBuilder.attributes(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)AttributeDimensionUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("Behavior", targetDepth)) {
                    context.nextToken();
                    segmentDimensionsBuilder.behavior(SegmentBehaviorsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Demographic", targetDepth)) {
                    context.nextToken();
                    segmentDimensionsBuilder.demographic(SegmentDemographicsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Location", targetDepth)) {
                    context.nextToken();
                    segmentDimensionsBuilder.location(SegmentLocationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("UserAttributes", targetDepth)) {
                    context.nextToken();
                    segmentDimensionsBuilder.userAttributes(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)AttributeDimensionUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (SegmentDimensions)segmentDimensionsBuilder.build();
    }

    public static SegmentDimensionsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

