/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pinpoint.model.Message;

public class MessageUnmarshaller
implements Unmarshaller<Message, JsonUnmarshallerContext> {
    private static final MessageUnmarshaller INSTANCE = new MessageUnmarshaller();

    public Message unmarshall(JsonUnmarshallerContext context) throws Exception {
        Message.Builder messageBuilder = Message.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Action", targetDepth)) {
                    context.nextToken();
                    messageBuilder.action((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Body", targetDepth)) {
                    context.nextToken();
                    messageBuilder.body((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ImageIconUrl", targetDepth)) {
                    context.nextToken();
                    messageBuilder.imageIconUrl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ImageSmallIconUrl", targetDepth)) {
                    context.nextToken();
                    messageBuilder.imageSmallIconUrl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ImageUrl", targetDepth)) {
                    context.nextToken();
                    messageBuilder.imageUrl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("JsonBody", targetDepth)) {
                    context.nextToken();
                    messageBuilder.jsonBody((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("MediaUrl", targetDepth)) {
                    context.nextToken();
                    messageBuilder.mediaUrl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SilentPush", targetDepth)) {
                    context.nextToken();
                    messageBuilder.silentPush((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("Title", targetDepth)) {
                    context.nextToken();
                    messageBuilder.title((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Url", targetDepth)) {
                    context.nextToken();
                    messageBuilder.url((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Message)messageBuilder.build();
    }

    public static MessageUnmarshaller getInstance() {
        return INSTANCE;
    }
}

