/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pinpoint.model.EndpointLocation;

public class EndpointLocationUnmarshaller
implements Unmarshaller<EndpointLocation, JsonUnmarshallerContext> {
    private static final EndpointLocationUnmarshaller INSTANCE = new EndpointLocationUnmarshaller();

    public EndpointLocation unmarshall(JsonUnmarshallerContext context) throws Exception {
        EndpointLocation.Builder endpointLocationBuilder = EndpointLocation.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("City", targetDepth)) {
                    context.nextToken();
                    endpointLocationBuilder.city((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Country", targetDepth)) {
                    context.nextToken();
                    endpointLocationBuilder.country((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Latitude", targetDepth)) {
                    context.nextToken();
                    endpointLocationBuilder.latitude((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("Longitude", targetDepth)) {
                    context.nextToken();
                    endpointLocationBuilder.longitude((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("PostalCode", targetDepth)) {
                    context.nextToken();
                    endpointLocationBuilder.postalCode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Region", targetDepth)) {
                    context.nextToken();
                    endpointLocationBuilder.region((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (EndpointLocation)endpointLocationBuilder.build();
    }

    public static EndpointLocationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

