/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.EndpointLocation;

@SdkInternalApi
public class EndpointLocationMarshaller {
    private static final MarshallingInfo<String> CITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("City").build();
    private static final MarshallingInfo<String> COUNTRY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Country").build();
    private static final MarshallingInfo<Double> LATITUDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Latitude").build();
    private static final MarshallingInfo<Double> LONGITUDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Longitude").build();
    private static final MarshallingInfo<String> POSTALCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PostalCode").build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Region").build();
    private static final EndpointLocationMarshaller INSTANCE = new EndpointLocationMarshaller();

    public static EndpointLocationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EndpointLocation endpointLocation, ProtocolMarshaller protocolMarshaller) {
        if (endpointLocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)endpointLocation.city(), CITY_BINDING);
            protocolMarshaller.marshall((Object)endpointLocation.country(), COUNTRY_BINDING);
            protocolMarshaller.marshall((Object)endpointLocation.latitude(), LATITUDE_BINDING);
            protocolMarshaller.marshall((Object)endpointLocation.longitude(), LONGITUDE_BINDING);
            protocolMarshaller.marshall((Object)endpointLocation.postalCode(), POSTALCODE_BINDING);
            protocolMarshaller.marshall((Object)endpointLocation.region(), REGION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

