/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pinpoint.model.EndpointBatchItem;
import software.amazon.awssdk.services.pinpoint.transform.EndpointDemographicUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.EndpointLocationUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.EndpointUserUnmarshaller;

public class EndpointBatchItemUnmarshaller
implements Unmarshaller<EndpointBatchItem, JsonUnmarshallerContext> {
    private static final EndpointBatchItemUnmarshaller INSTANCE = new EndpointBatchItemUnmarshaller();

    public EndpointBatchItem unmarshall(JsonUnmarshallerContext context) throws Exception {
        EndpointBatchItem.Builder endpointBatchItemBuilder = EndpointBatchItem.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Address", targetDepth)) {
                    context.nextToken();
                    endpointBatchItemBuilder.address((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Attributes", targetDepth)) {
                    context.nextToken();
                    endpointBatchItemBuilder.attributes(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)new ListUnmarshaller(context.getUnmarshaller(String.class))).unmarshall(context));
                }
                if (context.testExpression("ChannelType", targetDepth)) {
                    context.nextToken();
                    endpointBatchItemBuilder.channelType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Demographic", targetDepth)) {
                    context.nextToken();
                    endpointBatchItemBuilder.demographic(EndpointDemographicUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("EffectiveDate", targetDepth)) {
                    context.nextToken();
                    endpointBatchItemBuilder.effectiveDate((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("EndpointStatus", targetDepth)) {
                    context.nextToken();
                    endpointBatchItemBuilder.endpointStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Id", targetDepth)) {
                    context.nextToken();
                    endpointBatchItemBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Location", targetDepth)) {
                    context.nextToken();
                    endpointBatchItemBuilder.location(EndpointLocationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Metrics", targetDepth)) {
                    context.nextToken();
                    endpointBatchItemBuilder.metrics(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(Double.class)).unmarshall(context));
                }
                if (context.testExpression("OptOut", targetDepth)) {
                    context.nextToken();
                    endpointBatchItemBuilder.optOut((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RequestId", targetDepth)) {
                    context.nextToken();
                    endpointBatchItemBuilder.requestId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("User", targetDepth)) {
                    context.nextToken();
                    endpointBatchItemBuilder.user(EndpointUserUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (EndpointBatchItem)endpointBatchItemBuilder.build();
    }

    public static EndpointBatchItemUnmarshaller getInstance() {
        return INSTANCE;
    }
}

