/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pinpoint.model.DefaultMessage;

public class DefaultMessageUnmarshaller
implements Unmarshaller<DefaultMessage, JsonUnmarshallerContext> {
    private static final DefaultMessageUnmarshaller INSTANCE = new DefaultMessageUnmarshaller();

    public DefaultMessage unmarshall(JsonUnmarshallerContext context) throws Exception {
        DefaultMessage.Builder defaultMessageBuilder = DefaultMessage.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Body", targetDepth)) {
                    context.nextToken();
                    defaultMessageBuilder.body((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Substitutions", targetDepth)) {
                    context.nextToken();
                    defaultMessageBuilder.substitutions(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)new ListUnmarshaller(context.getUnmarshaller(String.class))).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (DefaultMessage)defaultMessageBuilder.build();
    }

    public static DefaultMessageUnmarshaller getInstance() {
        return INSTANCE;
    }
}

