/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.CampaignLimits;
import software.amazon.awssdk.services.pinpoint.model.QuietTime;
import software.amazon.awssdk.services.pinpoint.transform.WriteApplicationSettingsRequestMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class WriteApplicationSettingsRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, WriteApplicationSettingsRequest> {
    private final CampaignLimits limits;
    private final QuietTime quietTime;

    private WriteApplicationSettingsRequest(BuilderImpl builder) {
        this.limits = builder.limits;
        this.quietTime = builder.quietTime;
    }

    public CampaignLimits limits() {
        return this.limits;
    }

    public QuietTime quietTime() {
        return this.quietTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.limits() == null ? 0 : this.limits().hashCode());
        hashCode = 31 * hashCode + (this.quietTime() == null ? 0 : this.quietTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteApplicationSettingsRequest)) {
            return false;
        }
        WriteApplicationSettingsRequest other = (WriteApplicationSettingsRequest)obj;
        if (other.limits() == null ^ this.limits() == null) {
            return false;
        }
        if (other.limits() != null && !other.limits().equals(this.limits())) {
            return false;
        }
        if (other.quietTime() == null ^ this.quietTime() == null) {
            return false;
        }
        return other.quietTime() == null || other.quietTime().equals(this.quietTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.limits() != null) {
            sb.append("Limits: ").append(this.limits()).append(",");
        }
        if (this.quietTime() != null) {
            sb.append("QuietTime: ").append(this.quietTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WriteApplicationSettingsRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private CampaignLimits limits;
        private QuietTime quietTime;

        private BuilderImpl() {
        }

        private BuilderImpl(WriteApplicationSettingsRequest model) {
            this.setLimits(model.limits);
            this.setQuietTime(model.quietTime);
        }

        public final CampaignLimits getLimits() {
            return this.limits;
        }

        @Override
        public final Builder limits(CampaignLimits limits) {
            this.limits = limits;
            return this;
        }

        public final void setLimits(CampaignLimits limits) {
            this.limits = limits;
        }

        public final QuietTime getQuietTime() {
            return this.quietTime;
        }

        @Override
        public final Builder quietTime(QuietTime quietTime) {
            this.quietTime = quietTime;
            return this;
        }

        public final void setQuietTime(QuietTime quietTime) {
            this.quietTime = quietTime;
        }

        public WriteApplicationSettingsRequest build() {
            return new WriteApplicationSettingsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WriteApplicationSettingsRequest> {
        public Builder limits(CampaignLimits var1);

        public Builder quietTime(QuietTime var1);
    }
}

