/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.AttributeDimension;
import software.amazon.awssdk.services.pinpoint.model.MapOfAttributeDimensionCopier;
import software.amazon.awssdk.services.pinpoint.model.SegmentBehaviors;
import software.amazon.awssdk.services.pinpoint.model.SegmentDemographics;
import software.amazon.awssdk.services.pinpoint.model.SegmentLocation;
import software.amazon.awssdk.services.pinpoint.transform.SegmentDimensionsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SegmentDimensions
implements StructuredPojo,
ToCopyableBuilder<Builder, SegmentDimensions> {
    private final Map<String, AttributeDimension> attributes;
    private final SegmentBehaviors behavior;
    private final SegmentDemographics demographic;
    private final SegmentLocation location;
    private final Map<String, AttributeDimension> userAttributes;

    private SegmentDimensions(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.behavior = builder.behavior;
        this.demographic = builder.demographic;
        this.location = builder.location;
        this.userAttributes = builder.userAttributes;
    }

    public Map<String, AttributeDimension> attributes() {
        return this.attributes;
    }

    public SegmentBehaviors behavior() {
        return this.behavior;
    }

    public SegmentDemographics demographic() {
        return this.demographic;
    }

    public SegmentLocation location() {
        return this.location;
    }

    public Map<String, AttributeDimension> userAttributes() {
        return this.userAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attributes() == null ? 0 : this.attributes().hashCode());
        hashCode = 31 * hashCode + (this.behavior() == null ? 0 : this.behavior().hashCode());
        hashCode = 31 * hashCode + (this.demographic() == null ? 0 : this.demographic().hashCode());
        hashCode = 31 * hashCode + (this.location() == null ? 0 : this.location().hashCode());
        hashCode = 31 * hashCode + (this.userAttributes() == null ? 0 : this.userAttributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentDimensions)) {
            return false;
        }
        SegmentDimensions other = (SegmentDimensions)obj;
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        if (other.attributes() != null && !other.attributes().equals(this.attributes())) {
            return false;
        }
        if (other.behavior() == null ^ this.behavior() == null) {
            return false;
        }
        if (other.behavior() != null && !other.behavior().equals(this.behavior())) {
            return false;
        }
        if (other.demographic() == null ^ this.demographic() == null) {
            return false;
        }
        if (other.demographic() != null && !other.demographic().equals(this.demographic())) {
            return false;
        }
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        if (other.location() != null && !other.location().equals(this.location())) {
            return false;
        }
        if (other.userAttributes() == null ^ this.userAttributes() == null) {
            return false;
        }
        return other.userAttributes() == null || other.userAttributes().equals(this.userAttributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        if (this.behavior() != null) {
            sb.append("Behavior: ").append(this.behavior()).append(",");
        }
        if (this.demographic() != null) {
            sb.append("Demographic: ").append(this.demographic()).append(",");
        }
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        if (this.userAttributes() != null) {
            sb.append("UserAttributes: ").append(this.userAttributes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SegmentDimensionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Map<String, AttributeDimension> attributes;
        private SegmentBehaviors behavior;
        private SegmentDemographics demographic;
        private SegmentLocation location;
        private Map<String, AttributeDimension> userAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentDimensions model) {
            this.setAttributes(model.attributes);
            this.setBehavior(model.behavior);
            this.setDemographic(model.demographic);
            this.setLocation(model.location);
            this.setUserAttributes(model.userAttributes);
        }

        public final Map<String, AttributeDimension> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, AttributeDimension> attributes) {
            this.attributes = MapOfAttributeDimensionCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, AttributeDimension> attributes) {
            this.attributes = MapOfAttributeDimensionCopier.copy(attributes);
        }

        public final SegmentBehaviors getBehavior() {
            return this.behavior;
        }

        @Override
        public final Builder behavior(SegmentBehaviors behavior) {
            this.behavior = behavior;
            return this;
        }

        public final void setBehavior(SegmentBehaviors behavior) {
            this.behavior = behavior;
        }

        public final SegmentDemographics getDemographic() {
            return this.demographic;
        }

        @Override
        public final Builder demographic(SegmentDemographics demographic) {
            this.demographic = demographic;
            return this;
        }

        public final void setDemographic(SegmentDemographics demographic) {
            this.demographic = demographic;
        }

        public final SegmentLocation getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(SegmentLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(SegmentLocation location) {
            this.location = location;
        }

        public final Map<String, AttributeDimension> getUserAttributes() {
            return this.userAttributes;
        }

        @Override
        public final Builder userAttributes(Map<String, AttributeDimension> userAttributes) {
            this.userAttributes = MapOfAttributeDimensionCopier.copy(userAttributes);
            return this;
        }

        public final void setUserAttributes(Map<String, AttributeDimension> userAttributes) {
            this.userAttributes = MapOfAttributeDimensionCopier.copy(userAttributes);
        }

        public SegmentDimensions build() {
            return new SegmentDimensions(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SegmentDimensions> {
        public Builder attributes(Map<String, AttributeDimension> var1);

        public Builder behavior(SegmentBehaviors var1);

        public Builder demographic(SegmentDemographics var1);

        public Builder location(SegmentLocation var1);

        public Builder userAttributes(Map<String, AttributeDimension> var1);
    }
}

