/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.SetDimension;
import software.amazon.awssdk.services.pinpoint.transform.SegmentDemographicsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SegmentDemographics
implements StructuredPojo,
ToCopyableBuilder<Builder, SegmentDemographics> {
    private final SetDimension appVersion;
    private final SetDimension channel;
    private final SetDimension deviceType;
    private final SetDimension make;
    private final SetDimension model;
    private final SetDimension platform;

    private SegmentDemographics(BuilderImpl builder) {
        this.appVersion = builder.appVersion;
        this.channel = builder.channel;
        this.deviceType = builder.deviceType;
        this.make = builder.make;
        this.model = builder.model;
        this.platform = builder.platform;
    }

    public SetDimension appVersion() {
        return this.appVersion;
    }

    public SetDimension channel() {
        return this.channel;
    }

    public SetDimension deviceType() {
        return this.deviceType;
    }

    public SetDimension make() {
        return this.make;
    }

    public SetDimension model() {
        return this.model;
    }

    public SetDimension platform() {
        return this.platform;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.appVersion() == null ? 0 : this.appVersion().hashCode());
        hashCode = 31 * hashCode + (this.channel() == null ? 0 : this.channel().hashCode());
        hashCode = 31 * hashCode + (this.deviceType() == null ? 0 : this.deviceType().hashCode());
        hashCode = 31 * hashCode + (this.make() == null ? 0 : this.make().hashCode());
        hashCode = 31 * hashCode + (this.model() == null ? 0 : this.model().hashCode());
        hashCode = 31 * hashCode + (this.platform() == null ? 0 : this.platform().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentDemographics)) {
            return false;
        }
        SegmentDemographics other = (SegmentDemographics)obj;
        if (other.appVersion() == null ^ this.appVersion() == null) {
            return false;
        }
        if (other.appVersion() != null && !other.appVersion().equals(this.appVersion())) {
            return false;
        }
        if (other.channel() == null ^ this.channel() == null) {
            return false;
        }
        if (other.channel() != null && !other.channel().equals(this.channel())) {
            return false;
        }
        if (other.deviceType() == null ^ this.deviceType() == null) {
            return false;
        }
        if (other.deviceType() != null && !other.deviceType().equals(this.deviceType())) {
            return false;
        }
        if (other.make() == null ^ this.make() == null) {
            return false;
        }
        if (other.make() != null && !other.make().equals(this.make())) {
            return false;
        }
        if (other.model() == null ^ this.model() == null) {
            return false;
        }
        if (other.model() != null && !other.model().equals(this.model())) {
            return false;
        }
        if (other.platform() == null ^ this.platform() == null) {
            return false;
        }
        return other.platform() == null || other.platform().equals(this.platform());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.appVersion() != null) {
            sb.append("AppVersion: ").append(this.appVersion()).append(",");
        }
        if (this.channel() != null) {
            sb.append("Channel: ").append(this.channel()).append(",");
        }
        if (this.deviceType() != null) {
            sb.append("DeviceType: ").append(this.deviceType()).append(",");
        }
        if (this.make() != null) {
            sb.append("Make: ").append(this.make()).append(",");
        }
        if (this.model() != null) {
            sb.append("Model: ").append(this.model()).append(",");
        }
        if (this.platform() != null) {
            sb.append("Platform: ").append(this.platform()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SegmentDemographicsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private SetDimension appVersion;
        private SetDimension channel;
        private SetDimension deviceType;
        private SetDimension make;
        private SetDimension model;
        private SetDimension platform;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentDemographics model) {
            this.setAppVersion(model.appVersion);
            this.setChannel(model.channel);
            this.setDeviceType(model.deviceType);
            this.setMake(model.make);
            this.setModel(model.model);
            this.setPlatform(model.platform);
        }

        public final SetDimension getAppVersion() {
            return this.appVersion;
        }

        @Override
        public final Builder appVersion(SetDimension appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final void setAppVersion(SetDimension appVersion) {
            this.appVersion = appVersion;
        }

        public final SetDimension getChannel() {
            return this.channel;
        }

        @Override
        public final Builder channel(SetDimension channel) {
            this.channel = channel;
            return this;
        }

        public final void setChannel(SetDimension channel) {
            this.channel = channel;
        }

        public final SetDimension getDeviceType() {
            return this.deviceType;
        }

        @Override
        public final Builder deviceType(SetDimension deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public final void setDeviceType(SetDimension deviceType) {
            this.deviceType = deviceType;
        }

        public final SetDimension getMake() {
            return this.make;
        }

        @Override
        public final Builder make(SetDimension make) {
            this.make = make;
            return this;
        }

        public final void setMake(SetDimension make) {
            this.make = make;
        }

        public final SetDimension getModel() {
            return this.model;
        }

        @Override
        public final Builder model(SetDimension model) {
            this.model = model;
            return this;
        }

        public final void setModel(SetDimension model) {
            this.model = model;
        }

        public final SetDimension getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(SetDimension platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(SetDimension platform) {
            this.platform = platform;
        }

        public SegmentDemographics build() {
            return new SegmentDemographics(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SegmentDemographics> {
        public Builder appVersion(SetDimension var1);

        public Builder channel(SetDimension var1);

        public Builder deviceType(SetDimension var1);

        public Builder make(SetDimension var1);

        public Builder model(SetDimension var1);

        public Builder platform(SetDimension var1);
    }
}

