/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.Duration;
import software.amazon.awssdk.services.pinpoint.model.RecencyType;
import software.amazon.awssdk.services.pinpoint.transform.RecencyDimensionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RecencyDimension
implements StructuredPojo,
ToCopyableBuilder<Builder, RecencyDimension> {
    private final String duration;
    private final String recencyType;

    private RecencyDimension(BuilderImpl builder) {
        this.duration = builder.duration;
        this.recencyType = builder.recencyType;
    }

    public String duration() {
        return this.duration;
    }

    public String recencyType() {
        return this.recencyType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.duration() == null ? 0 : this.duration().hashCode());
        hashCode = 31 * hashCode + (this.recencyType() == null ? 0 : this.recencyType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecencyDimension)) {
            return false;
        }
        RecencyDimension other = (RecencyDimension)obj;
        if (other.duration() == null ^ this.duration() == null) {
            return false;
        }
        if (other.duration() != null && !other.duration().equals(this.duration())) {
            return false;
        }
        if (other.recencyType() == null ^ this.recencyType() == null) {
            return false;
        }
        return other.recencyType() == null || other.recencyType().equals(this.recencyType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.duration() != null) {
            sb.append("Duration: ").append(this.duration()).append(",");
        }
        if (this.recencyType() != null) {
            sb.append("RecencyType: ").append(this.recencyType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecencyDimensionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String duration;
        private String recencyType;

        private BuilderImpl() {
        }

        private BuilderImpl(RecencyDimension model) {
            this.setDuration(model.duration);
            this.setRecencyType(model.recencyType);
        }

        public final String getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(String duration) {
            this.duration = duration;
            return this;
        }

        @Override
        public final Builder duration(Duration duration) {
            this.duration(duration.toString());
            return this;
        }

        public final void setDuration(String duration) {
            this.duration = duration;
        }

        public final String getRecencyType() {
            return this.recencyType;
        }

        @Override
        public final Builder recencyType(String recencyType) {
            this.recencyType = recencyType;
            return this;
        }

        @Override
        public final Builder recencyType(RecencyType recencyType) {
            this.recencyType(recencyType.toString());
            return this;
        }

        public final void setRecencyType(String recencyType) {
            this.recencyType = recencyType;
        }

        public RecencyDimension build() {
            return new RecencyDimension(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RecencyDimension> {
        public Builder duration(String var1);

        public Builder duration(Duration var1);

        public Builder recencyType(String var1);

        public Builder recencyType(RecencyType var1);
    }
}

