/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.AddressConfiguration;
import software.amazon.awssdk.services.pinpoint.model.DirectMessageConfiguration;
import software.amazon.awssdk.services.pinpoint.model.MapOfAddressConfigurationCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.transform.MessageRequestMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MessageRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, MessageRequest> {
    private final Map<String, AddressConfiguration> addresses;
    private final Map<String, String> context;
    private final DirectMessageConfiguration messageConfiguration;

    private MessageRequest(BuilderImpl builder) {
        this.addresses = builder.addresses;
        this.context = builder.context;
        this.messageConfiguration = builder.messageConfiguration;
    }

    public Map<String, AddressConfiguration> addresses() {
        return this.addresses;
    }

    public Map<String, String> context() {
        return this.context;
    }

    public DirectMessageConfiguration messageConfiguration() {
        return this.messageConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.addresses() == null ? 0 : this.addresses().hashCode());
        hashCode = 31 * hashCode + (this.context() == null ? 0 : this.context().hashCode());
        hashCode = 31 * hashCode + (this.messageConfiguration() == null ? 0 : this.messageConfiguration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageRequest)) {
            return false;
        }
        MessageRequest other = (MessageRequest)obj;
        if (other.addresses() == null ^ this.addresses() == null) {
            return false;
        }
        if (other.addresses() != null && !other.addresses().equals(this.addresses())) {
            return false;
        }
        if (other.context() == null ^ this.context() == null) {
            return false;
        }
        if (other.context() != null && !other.context().equals(this.context())) {
            return false;
        }
        if (other.messageConfiguration() == null ^ this.messageConfiguration() == null) {
            return false;
        }
        return other.messageConfiguration() == null || other.messageConfiguration().equals(this.messageConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addresses() != null) {
            sb.append("Addresses: ").append(this.addresses()).append(",");
        }
        if (this.context() != null) {
            sb.append("Context: ").append(this.context()).append(",");
        }
        if (this.messageConfiguration() != null) {
            sb.append("MessageConfiguration: ").append(this.messageConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MessageRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Map<String, AddressConfiguration> addresses;
        private Map<String, String> context;
        private DirectMessageConfiguration messageConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageRequest model) {
            this.setAddresses(model.addresses);
            this.setContext(model.context);
            this.setMessageConfiguration(model.messageConfiguration);
        }

        public final Map<String, AddressConfiguration> getAddresses() {
            return this.addresses;
        }

        @Override
        public final Builder addresses(Map<String, AddressConfiguration> addresses) {
            this.addresses = MapOfAddressConfigurationCopier.copy(addresses);
            return this;
        }

        public final void setAddresses(Map<String, AddressConfiguration> addresses) {
            this.addresses = MapOfAddressConfigurationCopier.copy(addresses);
        }

        public final Map<String, String> getContext() {
            return this.context;
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = MapOf__stringCopier.copy(context);
            return this;
        }

        public final void setContext(Map<String, String> context) {
            this.context = MapOf__stringCopier.copy(context);
        }

        public final DirectMessageConfiguration getMessageConfiguration() {
            return this.messageConfiguration;
        }

        @Override
        public final Builder messageConfiguration(DirectMessageConfiguration messageConfiguration) {
            this.messageConfiguration = messageConfiguration;
            return this;
        }

        public final void setMessageConfiguration(DirectMessageConfiguration messageConfiguration) {
            this.messageConfiguration = messageConfiguration;
        }

        public MessageRequest build() {
            return new MessageRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MessageRequest> {
        public Builder addresses(Map<String, AddressConfiguration> var1);

        public Builder context(Map<String, String> var1);

        public Builder messageConfiguration(DirectMessageConfiguration var1);
    }
}

