/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetSegmentVersionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetSegmentVersionRequest> {
    private final String applicationId;
    private final String segmentId;
    private final String version;

    private GetSegmentVersionRequest(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.segmentId = builder.segmentId;
        this.version = builder.version;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String segmentId() {
        return this.segmentId;
    }

    public String version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationId() == null ? 0 : this.applicationId().hashCode());
        hashCode = 31 * hashCode + (this.segmentId() == null ? 0 : this.segmentId().hashCode());
        hashCode = 31 * hashCode + (this.version() == null ? 0 : this.version().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSegmentVersionRequest)) {
            return false;
        }
        GetSegmentVersionRequest other = (GetSegmentVersionRequest)((Object)obj);
        if (other.applicationId() == null ^ this.applicationId() == null) {
            return false;
        }
        if (other.applicationId() != null && !other.applicationId().equals(this.applicationId())) {
            return false;
        }
        if (other.segmentId() == null ^ this.segmentId() == null) {
            return false;
        }
        if (other.segmentId() != null && !other.segmentId().equals(this.segmentId())) {
            return false;
        }
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        return other.version() == null || other.version().equals(this.version());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.segmentId() != null) {
            sb.append("SegmentId: ").append(this.segmentId()).append(",");
        }
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String segmentId;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSegmentVersionRequest model) {
            this.setApplicationId(model.applicationId);
            this.setSegmentId(model.segmentId);
            this.setVersion(model.version);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getSegmentId() {
            return this.segmentId;
        }

        @Override
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public GetSegmentVersionRequest build() {
            return new GetSegmentVersionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetSegmentVersionRequest> {
        public Builder applicationId(String var1);

        public Builder segmentId(String var1);

        public Builder version(String var1);
    }
}

