/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.Action;
import software.amazon.awssdk.services.pinpoint.model.MapOfListOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.transform.GCMMessageMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GCMMessage
implements StructuredPojo,
ToCopyableBuilder<Builder, GCMMessage> {
    private final String action;
    private final String body;
    private final String collapseKey;
    private final Map<String, String> data;
    private final String iconReference;
    private final String imageIconUrl;
    private final String imageUrl;
    private final String rawContent;
    private final String restrictedPackageName;
    private final Boolean silentPush;
    private final String smallImageIconUrl;
    private final String sound;
    private final Map<String, List<String>> substitutions;
    private final String title;
    private final String url;

    private GCMMessage(BuilderImpl builder) {
        this.action = builder.action;
        this.body = builder.body;
        this.collapseKey = builder.collapseKey;
        this.data = builder.data;
        this.iconReference = builder.iconReference;
        this.imageIconUrl = builder.imageIconUrl;
        this.imageUrl = builder.imageUrl;
        this.rawContent = builder.rawContent;
        this.restrictedPackageName = builder.restrictedPackageName;
        this.silentPush = builder.silentPush;
        this.smallImageIconUrl = builder.smallImageIconUrl;
        this.sound = builder.sound;
        this.substitutions = builder.substitutions;
        this.title = builder.title;
        this.url = builder.url;
    }

    public String action() {
        return this.action;
    }

    public String body() {
        return this.body;
    }

    public String collapseKey() {
        return this.collapseKey;
    }

    public Map<String, String> data() {
        return this.data;
    }

    public String iconReference() {
        return this.iconReference;
    }

    public String imageIconUrl() {
        return this.imageIconUrl;
    }

    public String imageUrl() {
        return this.imageUrl;
    }

    public String rawContent() {
        return this.rawContent;
    }

    public String restrictedPackageName() {
        return this.restrictedPackageName;
    }

    public Boolean silentPush() {
        return this.silentPush;
    }

    public String smallImageIconUrl() {
        return this.smallImageIconUrl;
    }

    public String sound() {
        return this.sound;
    }

    public Map<String, List<String>> substitutions() {
        return this.substitutions;
    }

    public String title() {
        return this.title;
    }

    public String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.action() == null ? 0 : this.action().hashCode());
        hashCode = 31 * hashCode + (this.body() == null ? 0 : this.body().hashCode());
        hashCode = 31 * hashCode + (this.collapseKey() == null ? 0 : this.collapseKey().hashCode());
        hashCode = 31 * hashCode + (this.data() == null ? 0 : this.data().hashCode());
        hashCode = 31 * hashCode + (this.iconReference() == null ? 0 : this.iconReference().hashCode());
        hashCode = 31 * hashCode + (this.imageIconUrl() == null ? 0 : this.imageIconUrl().hashCode());
        hashCode = 31 * hashCode + (this.imageUrl() == null ? 0 : this.imageUrl().hashCode());
        hashCode = 31 * hashCode + (this.rawContent() == null ? 0 : this.rawContent().hashCode());
        hashCode = 31 * hashCode + (this.restrictedPackageName() == null ? 0 : this.restrictedPackageName().hashCode());
        hashCode = 31 * hashCode + (this.silentPush() == null ? 0 : this.silentPush().hashCode());
        hashCode = 31 * hashCode + (this.smallImageIconUrl() == null ? 0 : this.smallImageIconUrl().hashCode());
        hashCode = 31 * hashCode + (this.sound() == null ? 0 : this.sound().hashCode());
        hashCode = 31 * hashCode + (this.substitutions() == null ? 0 : this.substitutions().hashCode());
        hashCode = 31 * hashCode + (this.title() == null ? 0 : this.title().hashCode());
        hashCode = 31 * hashCode + (this.url() == null ? 0 : this.url().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GCMMessage)) {
            return false;
        }
        GCMMessage other = (GCMMessage)obj;
        if (other.action() == null ^ this.action() == null) {
            return false;
        }
        if (other.action() != null && !other.action().equals(this.action())) {
            return false;
        }
        if (other.body() == null ^ this.body() == null) {
            return false;
        }
        if (other.body() != null && !other.body().equals(this.body())) {
            return false;
        }
        if (other.collapseKey() == null ^ this.collapseKey() == null) {
            return false;
        }
        if (other.collapseKey() != null && !other.collapseKey().equals(this.collapseKey())) {
            return false;
        }
        if (other.data() == null ^ this.data() == null) {
            return false;
        }
        if (other.data() != null && !other.data().equals(this.data())) {
            return false;
        }
        if (other.iconReference() == null ^ this.iconReference() == null) {
            return false;
        }
        if (other.iconReference() != null && !other.iconReference().equals(this.iconReference())) {
            return false;
        }
        if (other.imageIconUrl() == null ^ this.imageIconUrl() == null) {
            return false;
        }
        if (other.imageIconUrl() != null && !other.imageIconUrl().equals(this.imageIconUrl())) {
            return false;
        }
        if (other.imageUrl() == null ^ this.imageUrl() == null) {
            return false;
        }
        if (other.imageUrl() != null && !other.imageUrl().equals(this.imageUrl())) {
            return false;
        }
        if (other.rawContent() == null ^ this.rawContent() == null) {
            return false;
        }
        if (other.rawContent() != null && !other.rawContent().equals(this.rawContent())) {
            return false;
        }
        if (other.restrictedPackageName() == null ^ this.restrictedPackageName() == null) {
            return false;
        }
        if (other.restrictedPackageName() != null && !other.restrictedPackageName().equals(this.restrictedPackageName())) {
            return false;
        }
        if (other.silentPush() == null ^ this.silentPush() == null) {
            return false;
        }
        if (other.silentPush() != null && !other.silentPush().equals(this.silentPush())) {
            return false;
        }
        if (other.smallImageIconUrl() == null ^ this.smallImageIconUrl() == null) {
            return false;
        }
        if (other.smallImageIconUrl() != null && !other.smallImageIconUrl().equals(this.smallImageIconUrl())) {
            return false;
        }
        if (other.sound() == null ^ this.sound() == null) {
            return false;
        }
        if (other.sound() != null && !other.sound().equals(this.sound())) {
            return false;
        }
        if (other.substitutions() == null ^ this.substitutions() == null) {
            return false;
        }
        if (other.substitutions() != null && !other.substitutions().equals(this.substitutions())) {
            return false;
        }
        if (other.title() == null ^ this.title() == null) {
            return false;
        }
        if (other.title() != null && !other.title().equals(this.title())) {
            return false;
        }
        if (other.url() == null ^ this.url() == null) {
            return false;
        }
        return other.url() == null || other.url().equals(this.url());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.action() != null) {
            sb.append("Action: ").append(this.action()).append(",");
        }
        if (this.body() != null) {
            sb.append("Body: ").append(this.body()).append(",");
        }
        if (this.collapseKey() != null) {
            sb.append("CollapseKey: ").append(this.collapseKey()).append(",");
        }
        if (this.data() != null) {
            sb.append("Data: ").append(this.data()).append(",");
        }
        if (this.iconReference() != null) {
            sb.append("IconReference: ").append(this.iconReference()).append(",");
        }
        if (this.imageIconUrl() != null) {
            sb.append("ImageIconUrl: ").append(this.imageIconUrl()).append(",");
        }
        if (this.imageUrl() != null) {
            sb.append("ImageUrl: ").append(this.imageUrl()).append(",");
        }
        if (this.rawContent() != null) {
            sb.append("RawContent: ").append(this.rawContent()).append(",");
        }
        if (this.restrictedPackageName() != null) {
            sb.append("RestrictedPackageName: ").append(this.restrictedPackageName()).append(",");
        }
        if (this.silentPush() != null) {
            sb.append("SilentPush: ").append(this.silentPush()).append(",");
        }
        if (this.smallImageIconUrl() != null) {
            sb.append("SmallImageIconUrl: ").append(this.smallImageIconUrl()).append(",");
        }
        if (this.sound() != null) {
            sb.append("Sound: ").append(this.sound()).append(",");
        }
        if (this.substitutions() != null) {
            sb.append("Substitutions: ").append(this.substitutions()).append(",");
        }
        if (this.title() != null) {
            sb.append("Title: ").append(this.title()).append(",");
        }
        if (this.url() != null) {
            sb.append("Url: ").append(this.url()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GCMMessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String action;
        private String body;
        private String collapseKey;
        private Map<String, String> data;
        private String iconReference;
        private String imageIconUrl;
        private String imageUrl;
        private String rawContent;
        private String restrictedPackageName;
        private Boolean silentPush;
        private String smallImageIconUrl;
        private String sound;
        private Map<String, List<String>> substitutions;
        private String title;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(GCMMessage model) {
            this.setAction(model.action);
            this.setBody(model.body);
            this.setCollapseKey(model.collapseKey);
            this.setData(model.data);
            this.setIconReference(model.iconReference);
            this.setImageIconUrl(model.imageIconUrl);
            this.setImageUrl(model.imageUrl);
            this.setRawContent(model.rawContent);
            this.setRestrictedPackageName(model.restrictedPackageName);
            this.setSilentPush(model.silentPush);
            this.setSmallImageIconUrl(model.smallImageIconUrl);
            this.setSound(model.sound);
            this.setSubstitutions(model.substitutions);
            this.setTitle(model.title);
            this.setUrl(model.url);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(Action action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getBody() {
            return this.body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final String getCollapseKey() {
            return this.collapseKey;
        }

        @Override
        public final Builder collapseKey(String collapseKey) {
            this.collapseKey = collapseKey;
            return this;
        }

        public final void setCollapseKey(String collapseKey) {
            this.collapseKey = collapseKey;
        }

        public final Map<String, String> getData() {
            return this.data;
        }

        @Override
        public final Builder data(Map<String, String> data) {
            this.data = MapOf__stringCopier.copy(data);
            return this;
        }

        public final void setData(Map<String, String> data) {
            this.data = MapOf__stringCopier.copy(data);
        }

        public final String getIconReference() {
            return this.iconReference;
        }

        @Override
        public final Builder iconReference(String iconReference) {
            this.iconReference = iconReference;
            return this;
        }

        public final void setIconReference(String iconReference) {
            this.iconReference = iconReference;
        }

        public final String getImageIconUrl() {
            return this.imageIconUrl;
        }

        @Override
        public final Builder imageIconUrl(String imageIconUrl) {
            this.imageIconUrl = imageIconUrl;
            return this;
        }

        public final void setImageIconUrl(String imageIconUrl) {
            this.imageIconUrl = imageIconUrl;
        }

        public final String getImageUrl() {
            return this.imageUrl;
        }

        @Override
        public final Builder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public final void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        public final String getRawContent() {
            return this.rawContent;
        }

        @Override
        public final Builder rawContent(String rawContent) {
            this.rawContent = rawContent;
            return this;
        }

        public final void setRawContent(String rawContent) {
            this.rawContent = rawContent;
        }

        public final String getRestrictedPackageName() {
            return this.restrictedPackageName;
        }

        @Override
        public final Builder restrictedPackageName(String restrictedPackageName) {
            this.restrictedPackageName = restrictedPackageName;
            return this;
        }

        public final void setRestrictedPackageName(String restrictedPackageName) {
            this.restrictedPackageName = restrictedPackageName;
        }

        public final Boolean getSilentPush() {
            return this.silentPush;
        }

        @Override
        public final Builder silentPush(Boolean silentPush) {
            this.silentPush = silentPush;
            return this;
        }

        public final void setSilentPush(Boolean silentPush) {
            this.silentPush = silentPush;
        }

        public final String getSmallImageIconUrl() {
            return this.smallImageIconUrl;
        }

        @Override
        public final Builder smallImageIconUrl(String smallImageIconUrl) {
            this.smallImageIconUrl = smallImageIconUrl;
            return this;
        }

        public final void setSmallImageIconUrl(String smallImageIconUrl) {
            this.smallImageIconUrl = smallImageIconUrl;
        }

        public final String getSound() {
            return this.sound;
        }

        @Override
        public final Builder sound(String sound) {
            this.sound = sound;
            return this;
        }

        public final void setSound(String sound) {
            this.sound = sound;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            return this.substitutions;
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public GCMMessage build() {
            return new GCMMessage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GCMMessage> {
        public Builder action(String var1);

        public Builder action(Action var1);

        public Builder body(String var1);

        public Builder collapseKey(String var1);

        public Builder data(Map<String, String> var1);

        public Builder iconReference(String var1);

        public Builder imageIconUrl(String var1);

        public Builder imageUrl(String var1);

        public Builder rawContent(String var1);

        public Builder restrictedPackageName(String var1);

        public Builder silentPush(Boolean var1);

        public Builder smallImageIconUrl(String var1);

        public Builder sound(String var1);

        public Builder substitutions(Map<String, ? extends Collection<String>> var1);

        public Builder title(String var1);

        public Builder url(String var1);
    }
}

