/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.transform.EndpointDemographicMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EndpointDemographic
implements StructuredPojo,
ToCopyableBuilder<Builder, EndpointDemographic> {
    private final String appVersion;
    private final String locale;
    private final String make;
    private final String model;
    private final String modelVersion;
    private final String platform;
    private final String platformVersion;
    private final String timezone;

    private EndpointDemographic(BuilderImpl builder) {
        this.appVersion = builder.appVersion;
        this.locale = builder.locale;
        this.make = builder.make;
        this.model = builder.model;
        this.modelVersion = builder.modelVersion;
        this.platform = builder.platform;
        this.platformVersion = builder.platformVersion;
        this.timezone = builder.timezone;
    }

    public String appVersion() {
        return this.appVersion;
    }

    public String locale() {
        return this.locale;
    }

    public String make() {
        return this.make;
    }

    public String model() {
        return this.model;
    }

    public String modelVersion() {
        return this.modelVersion;
    }

    public String platform() {
        return this.platform;
    }

    public String platformVersion() {
        return this.platformVersion;
    }

    public String timezone() {
        return this.timezone;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.appVersion() == null ? 0 : this.appVersion().hashCode());
        hashCode = 31 * hashCode + (this.locale() == null ? 0 : this.locale().hashCode());
        hashCode = 31 * hashCode + (this.make() == null ? 0 : this.make().hashCode());
        hashCode = 31 * hashCode + (this.model() == null ? 0 : this.model().hashCode());
        hashCode = 31 * hashCode + (this.modelVersion() == null ? 0 : this.modelVersion().hashCode());
        hashCode = 31 * hashCode + (this.platform() == null ? 0 : this.platform().hashCode());
        hashCode = 31 * hashCode + (this.platformVersion() == null ? 0 : this.platformVersion().hashCode());
        hashCode = 31 * hashCode + (this.timezone() == null ? 0 : this.timezone().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointDemographic)) {
            return false;
        }
        EndpointDemographic other = (EndpointDemographic)obj;
        if (other.appVersion() == null ^ this.appVersion() == null) {
            return false;
        }
        if (other.appVersion() != null && !other.appVersion().equals(this.appVersion())) {
            return false;
        }
        if (other.locale() == null ^ this.locale() == null) {
            return false;
        }
        if (other.locale() != null && !other.locale().equals(this.locale())) {
            return false;
        }
        if (other.make() == null ^ this.make() == null) {
            return false;
        }
        if (other.make() != null && !other.make().equals(this.make())) {
            return false;
        }
        if (other.model() == null ^ this.model() == null) {
            return false;
        }
        if (other.model() != null && !other.model().equals(this.model())) {
            return false;
        }
        if (other.modelVersion() == null ^ this.modelVersion() == null) {
            return false;
        }
        if (other.modelVersion() != null && !other.modelVersion().equals(this.modelVersion())) {
            return false;
        }
        if (other.platform() == null ^ this.platform() == null) {
            return false;
        }
        if (other.platform() != null && !other.platform().equals(this.platform())) {
            return false;
        }
        if (other.platformVersion() == null ^ this.platformVersion() == null) {
            return false;
        }
        if (other.platformVersion() != null && !other.platformVersion().equals(this.platformVersion())) {
            return false;
        }
        if (other.timezone() == null ^ this.timezone() == null) {
            return false;
        }
        return other.timezone() == null || other.timezone().equals(this.timezone());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.appVersion() != null) {
            sb.append("AppVersion: ").append(this.appVersion()).append(",");
        }
        if (this.locale() != null) {
            sb.append("Locale: ").append(this.locale()).append(",");
        }
        if (this.make() != null) {
            sb.append("Make: ").append(this.make()).append(",");
        }
        if (this.model() != null) {
            sb.append("Model: ").append(this.model()).append(",");
        }
        if (this.modelVersion() != null) {
            sb.append("ModelVersion: ").append(this.modelVersion()).append(",");
        }
        if (this.platform() != null) {
            sb.append("Platform: ").append(this.platform()).append(",");
        }
        if (this.platformVersion() != null) {
            sb.append("PlatformVersion: ").append(this.platformVersion()).append(",");
        }
        if (this.timezone() != null) {
            sb.append("Timezone: ").append(this.timezone()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointDemographicMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String appVersion;
        private String locale;
        private String make;
        private String model;
        private String modelVersion;
        private String platform;
        private String platformVersion;
        private String timezone;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointDemographic model) {
            this.setAppVersion(model.appVersion);
            this.setLocale(model.locale);
            this.setMake(model.make);
            this.setModel(model.model);
            this.setModelVersion(model.modelVersion);
            this.setPlatform(model.platform);
            this.setPlatformVersion(model.platformVersion);
            this.setTimezone(model.timezone);
        }

        public final String getAppVersion() {
            return this.appVersion;
        }

        @Override
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        public final String getLocale() {
            return this.locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public final String getMake() {
            return this.make;
        }

        @Override
        public final Builder make(String make) {
            this.make = make;
            return this;
        }

        public final void setMake(String make) {
            this.make = make;
        }

        public final String getModel() {
            return this.model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        public final String getModelVersion() {
            return this.modelVersion;
        }

        @Override
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public EndpointDemographic build() {
            return new EndpointDemographic(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EndpointDemographic> {
        public Builder appVersion(String var1);

        public Builder locale(String var1);

        public Builder make(String var1);

        public Builder model(String var1);

        public Builder modelVersion(String var1);

        public Builder platform(String var1);

        public Builder platformVersion(String var1);

        public Builder timezone(String var1);
    }
}

