/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum Duration {
    HR_24("HR_24"),
    DAY_7("DAY_7"),
    DAY_14("DAY_14"),
    DAY_30("DAY_30");

    private final String value;

    private Duration(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static Duration fromValue(String value) {
        if (StringUtils.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(Duration.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

