/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.APNSMessage;
import software.amazon.awssdk.services.pinpoint.model.DefaultMessage;
import software.amazon.awssdk.services.pinpoint.model.DefaultPushNotificationMessage;
import software.amazon.awssdk.services.pinpoint.model.GCMMessage;
import software.amazon.awssdk.services.pinpoint.model.SMSMessage;
import software.amazon.awssdk.services.pinpoint.transform.DirectMessageConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DirectMessageConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, DirectMessageConfiguration> {
    private final APNSMessage apnsMessage;
    private final DefaultMessage defaultMessage;
    private final DefaultPushNotificationMessage defaultPushNotificationMessage;
    private final GCMMessage gcmMessage;
    private final SMSMessage smsMessage;

    private DirectMessageConfiguration(BuilderImpl builder) {
        this.apnsMessage = builder.apnsMessage;
        this.defaultMessage = builder.defaultMessage;
        this.defaultPushNotificationMessage = builder.defaultPushNotificationMessage;
        this.gcmMessage = builder.gcmMessage;
        this.smsMessage = builder.smsMessage;
    }

    public APNSMessage apnsMessage() {
        return this.apnsMessage;
    }

    public DefaultMessage defaultMessage() {
        return this.defaultMessage;
    }

    public DefaultPushNotificationMessage defaultPushNotificationMessage() {
        return this.defaultPushNotificationMessage;
    }

    public GCMMessage gcmMessage() {
        return this.gcmMessage;
    }

    public SMSMessage smsMessage() {
        return this.smsMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.apnsMessage() == null ? 0 : this.apnsMessage().hashCode());
        hashCode = 31 * hashCode + (this.defaultMessage() == null ? 0 : this.defaultMessage().hashCode());
        hashCode = 31 * hashCode + (this.defaultPushNotificationMessage() == null ? 0 : this.defaultPushNotificationMessage().hashCode());
        hashCode = 31 * hashCode + (this.gcmMessage() == null ? 0 : this.gcmMessage().hashCode());
        hashCode = 31 * hashCode + (this.smsMessage() == null ? 0 : this.smsMessage().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectMessageConfiguration)) {
            return false;
        }
        DirectMessageConfiguration other = (DirectMessageConfiguration)obj;
        if (other.apnsMessage() == null ^ this.apnsMessage() == null) {
            return false;
        }
        if (other.apnsMessage() != null && !other.apnsMessage().equals(this.apnsMessage())) {
            return false;
        }
        if (other.defaultMessage() == null ^ this.defaultMessage() == null) {
            return false;
        }
        if (other.defaultMessage() != null && !other.defaultMessage().equals(this.defaultMessage())) {
            return false;
        }
        if (other.defaultPushNotificationMessage() == null ^ this.defaultPushNotificationMessage() == null) {
            return false;
        }
        if (other.defaultPushNotificationMessage() != null && !other.defaultPushNotificationMessage().equals(this.defaultPushNotificationMessage())) {
            return false;
        }
        if (other.gcmMessage() == null ^ this.gcmMessage() == null) {
            return false;
        }
        if (other.gcmMessage() != null && !other.gcmMessage().equals(this.gcmMessage())) {
            return false;
        }
        if (other.smsMessage() == null ^ this.smsMessage() == null) {
            return false;
        }
        return other.smsMessage() == null || other.smsMessage().equals(this.smsMessage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apnsMessage() != null) {
            sb.append("APNSMessage: ").append(this.apnsMessage()).append(",");
        }
        if (this.defaultMessage() != null) {
            sb.append("DefaultMessage: ").append(this.defaultMessage()).append(",");
        }
        if (this.defaultPushNotificationMessage() != null) {
            sb.append("DefaultPushNotificationMessage: ").append(this.defaultPushNotificationMessage()).append(",");
        }
        if (this.gcmMessage() != null) {
            sb.append("GCMMessage: ").append(this.gcmMessage()).append(",");
        }
        if (this.smsMessage() != null) {
            sb.append("SMSMessage: ").append(this.smsMessage()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DirectMessageConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private APNSMessage apnsMessage;
        private DefaultMessage defaultMessage;
        private DefaultPushNotificationMessage defaultPushNotificationMessage;
        private GCMMessage gcmMessage;
        private SMSMessage smsMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DirectMessageConfiguration model) {
            this.setAPNSMessage(model.apnsMessage);
            this.setDefaultMessage(model.defaultMessage);
            this.setDefaultPushNotificationMessage(model.defaultPushNotificationMessage);
            this.setGCMMessage(model.gcmMessage);
            this.setSMSMessage(model.smsMessage);
        }

        public final APNSMessage getAPNSMessage() {
            return this.apnsMessage;
        }

        @Override
        public final Builder apnsMessage(APNSMessage apnsMessage) {
            this.apnsMessage = apnsMessage;
            return this;
        }

        public final void setAPNSMessage(APNSMessage apnsMessage) {
            this.apnsMessage = apnsMessage;
        }

        public final DefaultMessage getDefaultMessage() {
            return this.defaultMessage;
        }

        @Override
        public final Builder defaultMessage(DefaultMessage defaultMessage) {
            this.defaultMessage = defaultMessage;
            return this;
        }

        public final void setDefaultMessage(DefaultMessage defaultMessage) {
            this.defaultMessage = defaultMessage;
        }

        public final DefaultPushNotificationMessage getDefaultPushNotificationMessage() {
            return this.defaultPushNotificationMessage;
        }

        @Override
        public final Builder defaultPushNotificationMessage(DefaultPushNotificationMessage defaultPushNotificationMessage) {
            this.defaultPushNotificationMessage = defaultPushNotificationMessage;
            return this;
        }

        public final void setDefaultPushNotificationMessage(DefaultPushNotificationMessage defaultPushNotificationMessage) {
            this.defaultPushNotificationMessage = defaultPushNotificationMessage;
        }

        public final GCMMessage getGCMMessage() {
            return this.gcmMessage;
        }

        @Override
        public final Builder gcmMessage(GCMMessage gcmMessage) {
            this.gcmMessage = gcmMessage;
            return this;
        }

        public final void setGCMMessage(GCMMessage gcmMessage) {
            this.gcmMessage = gcmMessage;
        }

        public final SMSMessage getSMSMessage() {
            return this.smsMessage;
        }

        @Override
        public final Builder smsMessage(SMSMessage smsMessage) {
            this.smsMessage = smsMessage;
            return this;
        }

        public final void setSMSMessage(SMSMessage smsMessage) {
            this.smsMessage = smsMessage;
        }

        public DirectMessageConfiguration build() {
            return new DirectMessageConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DirectMessageConfiguration> {
        public Builder apnsMessage(APNSMessage var1);

        public Builder defaultMessage(DefaultMessage var1);

        public Builder defaultPushNotificationMessage(DefaultPushNotificationMessage var1);

        public Builder gcmMessage(GCMMessage var1);

        public Builder smsMessage(SMSMessage var1);
    }
}

