/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pinpoint.model.EventStream;

public class EventStreamUnmarshaller
implements Unmarshaller<EventStream, JsonUnmarshallerContext> {
    private static EventStreamUnmarshaller INSTANCE;

    public EventStream unmarshall(JsonUnmarshallerContext context) throws Exception {
        EventStream.Builder eventStreamBuilder = EventStream.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ApplicationId", targetDepth)) {
                    context.nextToken();
                    eventStreamBuilder.applicationId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DestinationStreamArn", targetDepth)) {
                    context.nextToken();
                    eventStreamBuilder.destinationStreamArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ExternalId", targetDepth)) {
                    context.nextToken();
                    eventStreamBuilder.externalId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastModifiedDate", targetDepth)) {
                    context.nextToken();
                    eventStreamBuilder.lastModifiedDate((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastUpdatedBy", targetDepth)) {
                    context.nextToken();
                    eventStreamBuilder.lastUpdatedBy((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RoleArn", targetDepth)) {
                    context.nextToken();
                    eventStreamBuilder.roleArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (EventStream)eventStreamBuilder.build();
    }

    public static EventStreamUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EventStreamUnmarshaller();
        }
        return INSTANCE;
    }
}

