/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.SegmentDimensions;
import software.amazon.awssdk.services.pinpoint.model.SegmentImportResource;
import software.amazon.awssdk.services.pinpoint.model.SegmentType;
import software.amazon.awssdk.services.pinpoint.transform.SegmentResponseMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SegmentResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, SegmentResponse> {
    private final String applicationId;
    private final String creationDate;
    private final SegmentDimensions dimensions;
    private final String id;
    private final SegmentImportResource importDefinition;
    private final String lastModifiedDate;
    private final String name;
    private final String segmentType;
    private final Integer version;

    private SegmentResponse(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.creationDate = builder.creationDate;
        this.dimensions = builder.dimensions;
        this.id = builder.id;
        this.importDefinition = builder.importDefinition;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.name = builder.name;
        this.segmentType = builder.segmentType;
        this.version = builder.version;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String creationDate() {
        return this.creationDate;
    }

    public SegmentDimensions dimensions() {
        return this.dimensions;
    }

    public String id() {
        return this.id;
    }

    public SegmentImportResource importDefinition() {
        return this.importDefinition;
    }

    public String lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String name() {
        return this.name;
    }

    public String segmentType() {
        return this.segmentType;
    }

    public Integer version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationId() == null ? 0 : this.applicationId().hashCode());
        hashCode = 31 * hashCode + (this.creationDate() == null ? 0 : this.creationDate().hashCode());
        hashCode = 31 * hashCode + (this.dimensions() == null ? 0 : this.dimensions().hashCode());
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.importDefinition() == null ? 0 : this.importDefinition().hashCode());
        hashCode = 31 * hashCode + (this.lastModifiedDate() == null ? 0 : this.lastModifiedDate().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.segmentType() == null ? 0 : this.segmentType().hashCode());
        hashCode = 31 * hashCode + (this.version() == null ? 0 : this.version().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentResponse)) {
            return false;
        }
        SegmentResponse other = (SegmentResponse)obj;
        if (other.applicationId() == null ^ this.applicationId() == null) {
            return false;
        }
        if (other.applicationId() != null && !other.applicationId().equals(this.applicationId())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.dimensions() == null ^ this.dimensions() == null) {
            return false;
        }
        if (other.dimensions() != null && !other.dimensions().equals(this.dimensions())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.importDefinition() == null ^ this.importDefinition() == null) {
            return false;
        }
        if (other.importDefinition() != null && !other.importDefinition().equals(this.importDefinition())) {
            return false;
        }
        if (other.lastModifiedDate() == null ^ this.lastModifiedDate() == null) {
            return false;
        }
        if (other.lastModifiedDate() != null && !other.lastModifiedDate().equals(this.lastModifiedDate())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.segmentType() == null ^ this.segmentType() == null) {
            return false;
        }
        if (other.segmentType() != null && !other.segmentType().equals(this.segmentType())) {
            return false;
        }
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        return other.version() == null || other.version().equals(this.version());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        if (this.dimensions() != null) {
            sb.append("Dimensions: ").append(this.dimensions()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.importDefinition() != null) {
            sb.append("ImportDefinition: ").append(this.importDefinition()).append(",");
        }
        if (this.lastModifiedDate() != null) {
            sb.append("LastModifiedDate: ").append(this.lastModifiedDate()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.segmentType() != null) {
            sb.append("SegmentType: ").append(this.segmentType()).append(",");
        }
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SegmentResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String creationDate;
        private SegmentDimensions dimensions;
        private String id;
        private SegmentImportResource importDefinition;
        private String lastModifiedDate;
        private String name;
        private String segmentType;
        private Integer version;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentResponse model) {
            this.setApplicationId(model.applicationId);
            this.setCreationDate(model.creationDate);
            this.setDimensions(model.dimensions);
            this.setId(model.id);
            this.setImportDefinition(model.importDefinition);
            this.setLastModifiedDate(model.lastModifiedDate);
            this.setName(model.name);
            this.setSegmentType(model.segmentType);
            this.setVersion(model.version);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final SegmentDimensions getDimensions() {
            return this.dimensions;
        }

        @Override
        public final Builder dimensions(SegmentDimensions dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final void setDimensions(SegmentDimensions dimensions) {
            this.dimensions = dimensions;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final SegmentImportResource getImportDefinition() {
            return this.importDefinition;
        }

        @Override
        public final Builder importDefinition(SegmentImportResource importDefinition) {
            this.importDefinition = importDefinition;
            return this;
        }

        public final void setImportDefinition(SegmentImportResource importDefinition) {
            this.importDefinition = importDefinition;
        }

        public final String getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSegmentType() {
            return this.segmentType;
        }

        @Override
        public final Builder segmentType(String segmentType) {
            this.segmentType = segmentType;
            return this;
        }

        @Override
        public final Builder segmentType(SegmentType segmentType) {
            this.segmentType(segmentType.toString());
            return this;
        }

        public final void setSegmentType(String segmentType) {
            this.segmentType = segmentType;
        }

        public final void setSegmentType(SegmentType segmentType) {
            this.segmentType(segmentType.toString());
        }

        public final Integer getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        public SegmentResponse build() {
            return new SegmentResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SegmentResponse> {
        public Builder applicationId(String var1);

        public Builder creationDate(String var1);

        public Builder dimensions(SegmentDimensions var1);

        public Builder id(String var1);

        public Builder importDefinition(SegmentImportResource var1);

        public Builder lastModifiedDate(String var1);

        public Builder name(String var1);

        public Builder segmentType(String var1);

        public Builder segmentType(SegmentType var1);

        public Builder version(Integer var1);
    }
}

