/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.pinpoint.model.WriteEventStream;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutEventStreamRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutEventStreamRequest> {
    private final String applicationId;
    private final WriteEventStream writeEventStream;

    private PutEventStreamRequest(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.writeEventStream = builder.writeEventStream;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public WriteEventStream writeEventStream() {
        return this.writeEventStream;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationId() == null ? 0 : this.applicationId().hashCode());
        hashCode = 31 * hashCode + (this.writeEventStream() == null ? 0 : this.writeEventStream().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEventStreamRequest)) {
            return false;
        }
        PutEventStreamRequest other = (PutEventStreamRequest)((Object)obj);
        if (other.applicationId() == null ^ this.applicationId() == null) {
            return false;
        }
        if (other.applicationId() != null && !other.applicationId().equals(this.applicationId())) {
            return false;
        }
        if (other.writeEventStream() == null ^ this.writeEventStream() == null) {
            return false;
        }
        return other.writeEventStream() == null || other.writeEventStream().equals(this.writeEventStream());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.writeEventStream() != null) {
            sb.append("WriteEventStream: ").append(this.writeEventStream()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private WriteEventStream writeEventStream;

        private BuilderImpl() {
        }

        private BuilderImpl(PutEventStreamRequest model) {
            this.setApplicationId(model.applicationId);
            this.setWriteEventStream(model.writeEventStream);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final WriteEventStream getWriteEventStream() {
            return this.writeEventStream;
        }

        @Override
        public final Builder writeEventStream(WriteEventStream writeEventStream) {
            this.writeEventStream = writeEventStream;
            return this;
        }

        public final void setWriteEventStream(WriteEventStream writeEventStream) {
            this.writeEventStream = writeEventStream;
        }

        public PutEventStreamRequest build() {
            return new PutEventStreamRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutEventStreamRequest> {
        public Builder applicationId(String var1);

        public Builder writeEventStream(WriteEventStream var1);
    }
}

