/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.DeliveryStatus;
import software.amazon.awssdk.services.pinpoint.transform.MessageResultMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MessageResult
implements StructuredPojo,
ToCopyableBuilder<Builder, MessageResult> {
    private final String deliveryStatus;
    private final Integer statusCode;
    private final String statusMessage;
    private final String updatedToken;

    private MessageResult(BuilderImpl builder) {
        this.deliveryStatus = builder.deliveryStatus;
        this.statusCode = builder.statusCode;
        this.statusMessage = builder.statusMessage;
        this.updatedToken = builder.updatedToken;
    }

    public String deliveryStatus() {
        return this.deliveryStatus;
    }

    public Integer statusCode() {
        return this.statusCode;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public String updatedToken() {
        return this.updatedToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deliveryStatus() == null ? 0 : this.deliveryStatus().hashCode());
        hashCode = 31 * hashCode + (this.statusCode() == null ? 0 : this.statusCode().hashCode());
        hashCode = 31 * hashCode + (this.statusMessage() == null ? 0 : this.statusMessage().hashCode());
        hashCode = 31 * hashCode + (this.updatedToken() == null ? 0 : this.updatedToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageResult)) {
            return false;
        }
        MessageResult other = (MessageResult)obj;
        if (other.deliveryStatus() == null ^ this.deliveryStatus() == null) {
            return false;
        }
        if (other.deliveryStatus() != null && !other.deliveryStatus().equals(this.deliveryStatus())) {
            return false;
        }
        if (other.statusCode() == null ^ this.statusCode() == null) {
            return false;
        }
        if (other.statusCode() != null && !other.statusCode().equals(this.statusCode())) {
            return false;
        }
        if (other.statusMessage() == null ^ this.statusMessage() == null) {
            return false;
        }
        if (other.statusMessage() != null && !other.statusMessage().equals(this.statusMessage())) {
            return false;
        }
        if (other.updatedToken() == null ^ this.updatedToken() == null) {
            return false;
        }
        return other.updatedToken() == null || other.updatedToken().equals(this.updatedToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deliveryStatus() != null) {
            sb.append("DeliveryStatus: ").append(this.deliveryStatus()).append(",");
        }
        if (this.statusCode() != null) {
            sb.append("StatusCode: ").append(this.statusCode()).append(",");
        }
        if (this.statusMessage() != null) {
            sb.append("StatusMessage: ").append(this.statusMessage()).append(",");
        }
        if (this.updatedToken() != null) {
            sb.append("UpdatedToken: ").append(this.updatedToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MessageResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String deliveryStatus;
        private Integer statusCode;
        private String statusMessage;
        private String updatedToken;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageResult model) {
            this.setDeliveryStatus(model.deliveryStatus);
            this.setStatusCode(model.statusCode);
            this.setStatusMessage(model.statusMessage);
            this.setUpdatedToken(model.updatedToken);
        }

        public final String getDeliveryStatus() {
            return this.deliveryStatus;
        }

        @Override
        public final Builder deliveryStatus(String deliveryStatus) {
            this.deliveryStatus = deliveryStatus;
            return this;
        }

        @Override
        public final Builder deliveryStatus(DeliveryStatus deliveryStatus) {
            this.deliveryStatus(deliveryStatus.toString());
            return this;
        }

        public final void setDeliveryStatus(String deliveryStatus) {
            this.deliveryStatus = deliveryStatus;
        }

        public final void setDeliveryStatus(DeliveryStatus deliveryStatus) {
            this.deliveryStatus(deliveryStatus.toString());
        }

        public final Integer getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getUpdatedToken() {
            return this.updatedToken;
        }

        @Override
        public final Builder updatedToken(String updatedToken) {
            this.updatedToken = updatedToken;
            return this;
        }

        public final void setUpdatedToken(String updatedToken) {
            this.updatedToken = updatedToken;
        }

        public MessageResult build() {
            return new MessageResult(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MessageResult> {
        public Builder deliveryStatus(String var1);

        public Builder deliveryStatus(DeliveryStatus var1);

        public Builder statusCode(Integer var1);

        public Builder statusMessage(String var1);

        public Builder updatedToken(String var1);
    }
}

