/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetSegmentImportJobsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetSegmentImportJobsRequest> {
    private final String applicationId;
    private final String pageSize;
    private final String segmentId;
    private final String token;

    private GetSegmentImportJobsRequest(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.pageSize = builder.pageSize;
        this.segmentId = builder.segmentId;
        this.token = builder.token;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String pageSize() {
        return this.pageSize;
    }

    public String segmentId() {
        return this.segmentId;
    }

    public String token() {
        return this.token;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationId() == null ? 0 : this.applicationId().hashCode());
        hashCode = 31 * hashCode + (this.pageSize() == null ? 0 : this.pageSize().hashCode());
        hashCode = 31 * hashCode + (this.segmentId() == null ? 0 : this.segmentId().hashCode());
        hashCode = 31 * hashCode + (this.token() == null ? 0 : this.token().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSegmentImportJobsRequest)) {
            return false;
        }
        GetSegmentImportJobsRequest other = (GetSegmentImportJobsRequest)((Object)obj);
        if (other.applicationId() == null ^ this.applicationId() == null) {
            return false;
        }
        if (other.applicationId() != null && !other.applicationId().equals(this.applicationId())) {
            return false;
        }
        if (other.pageSize() == null ^ this.pageSize() == null) {
            return false;
        }
        if (other.pageSize() != null && !other.pageSize().equals(this.pageSize())) {
            return false;
        }
        if (other.segmentId() == null ^ this.segmentId() == null) {
            return false;
        }
        if (other.segmentId() != null && !other.segmentId().equals(this.segmentId())) {
            return false;
        }
        if (other.token() == null ^ this.token() == null) {
            return false;
        }
        return other.token() == null || other.token().equals(this.token());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.pageSize() != null) {
            sb.append("PageSize: ").append(this.pageSize()).append(",");
        }
        if (this.segmentId() != null) {
            sb.append("SegmentId: ").append(this.segmentId()).append(",");
        }
        if (this.token() != null) {
            sb.append("Token: ").append(this.token()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String pageSize;
        private String segmentId;
        private String token;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSegmentImportJobsRequest model) {
            this.setApplicationId(model.applicationId);
            this.setPageSize(model.pageSize);
            this.setSegmentId(model.segmentId);
            this.setToken(model.token);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(String pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(String pageSize) {
            this.pageSize = pageSize;
        }

        public final String getSegmentId() {
            return this.segmentId;
        }

        @Override
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        public final String getToken() {
            return this.token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        public GetSegmentImportJobsRequest build() {
            return new GetSegmentImportJobsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetSegmentImportJobsRequest> {
        public Builder applicationId(String var1);

        public Builder pageSize(String var1);

        public Builder segmentId(String var1);

        public Builder token(String var1);
    }
}

