/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.transform.EventStreamMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EventStream
implements StructuredPojo,
ToCopyableBuilder<Builder, EventStream> {
    private final String applicationId;
    private final String destinationStreamArn;
    private final String externalId;
    private final String lastModifiedDate;
    private final String lastUpdatedBy;
    private final String roleArn;

    private EventStream(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.destinationStreamArn = builder.destinationStreamArn;
        this.externalId = builder.externalId;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.lastUpdatedBy = builder.lastUpdatedBy;
        this.roleArn = builder.roleArn;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String destinationStreamArn() {
        return this.destinationStreamArn;
    }

    public String externalId() {
        return this.externalId;
    }

    public String lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String lastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationId() == null ? 0 : this.applicationId().hashCode());
        hashCode = 31 * hashCode + (this.destinationStreamArn() == null ? 0 : this.destinationStreamArn().hashCode());
        hashCode = 31 * hashCode + (this.externalId() == null ? 0 : this.externalId().hashCode());
        hashCode = 31 * hashCode + (this.lastModifiedDate() == null ? 0 : this.lastModifiedDate().hashCode());
        hashCode = 31 * hashCode + (this.lastUpdatedBy() == null ? 0 : this.lastUpdatedBy().hashCode());
        hashCode = 31 * hashCode + (this.roleArn() == null ? 0 : this.roleArn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventStream)) {
            return false;
        }
        EventStream other = (EventStream)obj;
        if (other.applicationId() == null ^ this.applicationId() == null) {
            return false;
        }
        if (other.applicationId() != null && !other.applicationId().equals(this.applicationId())) {
            return false;
        }
        if (other.destinationStreamArn() == null ^ this.destinationStreamArn() == null) {
            return false;
        }
        if (other.destinationStreamArn() != null && !other.destinationStreamArn().equals(this.destinationStreamArn())) {
            return false;
        }
        if (other.externalId() == null ^ this.externalId() == null) {
            return false;
        }
        if (other.externalId() != null && !other.externalId().equals(this.externalId())) {
            return false;
        }
        if (other.lastModifiedDate() == null ^ this.lastModifiedDate() == null) {
            return false;
        }
        if (other.lastModifiedDate() != null && !other.lastModifiedDate().equals(this.lastModifiedDate())) {
            return false;
        }
        if (other.lastUpdatedBy() == null ^ this.lastUpdatedBy() == null) {
            return false;
        }
        if (other.lastUpdatedBy() != null && !other.lastUpdatedBy().equals(this.lastUpdatedBy())) {
            return false;
        }
        if (other.roleArn() == null ^ this.roleArn() == null) {
            return false;
        }
        return other.roleArn() == null || other.roleArn().equals(this.roleArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.destinationStreamArn() != null) {
            sb.append("DestinationStreamArn: ").append(this.destinationStreamArn()).append(",");
        }
        if (this.externalId() != null) {
            sb.append("ExternalId: ").append(this.externalId()).append(",");
        }
        if (this.lastModifiedDate() != null) {
            sb.append("LastModifiedDate: ").append(this.lastModifiedDate()).append(",");
        }
        if (this.lastUpdatedBy() != null) {
            sb.append("LastUpdatedBy: ").append(this.lastUpdatedBy()).append(",");
        }
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventStreamMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String destinationStreamArn;
        private String externalId;
        private String lastModifiedDate;
        private String lastUpdatedBy;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EventStream model) {
            this.setApplicationId(model.applicationId);
            this.setDestinationStreamArn(model.destinationStreamArn);
            this.setExternalId(model.externalId);
            this.setLastModifiedDate(model.lastModifiedDate);
            this.setLastUpdatedBy(model.lastUpdatedBy);
            this.setRoleArn(model.roleArn);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getDestinationStreamArn() {
            return this.destinationStreamArn;
        }

        @Override
        public final Builder destinationStreamArn(String destinationStreamArn) {
            this.destinationStreamArn = destinationStreamArn;
            return this;
        }

        public final void setDestinationStreamArn(String destinationStreamArn) {
            this.destinationStreamArn = destinationStreamArn;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        public final String getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getLastUpdatedBy() {
            return this.lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public EventStream build() {
            return new EventStream(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EventStream> {
        public Builder applicationId(String var1);

        public Builder destinationStreamArn(String var1);

        public Builder externalId(String var1);

        public Builder lastModifiedDate(String var1);

        public Builder lastUpdatedBy(String var1);

        public Builder roleArn(String var1);
    }
}

