/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.transform.EndpointLocationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EndpointLocation
implements StructuredPojo,
ToCopyableBuilder<Builder, EndpointLocation> {
    private final String city;
    private final String country;
    private final Double latitude;
    private final Double longitude;
    private final String postalCode;
    private final String region;

    private EndpointLocation(BuilderImpl builder) {
        this.city = builder.city;
        this.country = builder.country;
        this.latitude = builder.latitude;
        this.longitude = builder.longitude;
        this.postalCode = builder.postalCode;
        this.region = builder.region;
    }

    public String city() {
        return this.city;
    }

    public String country() {
        return this.country;
    }

    public Double latitude() {
        return this.latitude;
    }

    public Double longitude() {
        return this.longitude;
    }

    public String postalCode() {
        return this.postalCode;
    }

    public String region() {
        return this.region;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.city() == null ? 0 : this.city().hashCode());
        hashCode = 31 * hashCode + (this.country() == null ? 0 : this.country().hashCode());
        hashCode = 31 * hashCode + (this.latitude() == null ? 0 : this.latitude().hashCode());
        hashCode = 31 * hashCode + (this.longitude() == null ? 0 : this.longitude().hashCode());
        hashCode = 31 * hashCode + (this.postalCode() == null ? 0 : this.postalCode().hashCode());
        hashCode = 31 * hashCode + (this.region() == null ? 0 : this.region().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointLocation)) {
            return false;
        }
        EndpointLocation other = (EndpointLocation)obj;
        if (other.city() == null ^ this.city() == null) {
            return false;
        }
        if (other.city() != null && !other.city().equals(this.city())) {
            return false;
        }
        if (other.country() == null ^ this.country() == null) {
            return false;
        }
        if (other.country() != null && !other.country().equals(this.country())) {
            return false;
        }
        if (other.latitude() == null ^ this.latitude() == null) {
            return false;
        }
        if (other.latitude() != null && !other.latitude().equals(this.latitude())) {
            return false;
        }
        if (other.longitude() == null ^ this.longitude() == null) {
            return false;
        }
        if (other.longitude() != null && !other.longitude().equals(this.longitude())) {
            return false;
        }
        if (other.postalCode() == null ^ this.postalCode() == null) {
            return false;
        }
        if (other.postalCode() != null && !other.postalCode().equals(this.postalCode())) {
            return false;
        }
        if (other.region() == null ^ this.region() == null) {
            return false;
        }
        return other.region() == null || other.region().equals(this.region());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.city() != null) {
            sb.append("City: ").append(this.city()).append(",");
        }
        if (this.country() != null) {
            sb.append("Country: ").append(this.country()).append(",");
        }
        if (this.latitude() != null) {
            sb.append("Latitude: ").append(this.latitude()).append(",");
        }
        if (this.longitude() != null) {
            sb.append("Longitude: ").append(this.longitude()).append(",");
        }
        if (this.postalCode() != null) {
            sb.append("PostalCode: ").append(this.postalCode()).append(",");
        }
        if (this.region() != null) {
            sb.append("Region: ").append(this.region()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointLocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String city;
        private String country;
        private Double latitude;
        private Double longitude;
        private String postalCode;
        private String region;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointLocation model) {
            this.setCity(model.city);
            this.setCountry(model.country);
            this.setLatitude(model.latitude);
            this.setLongitude(model.longitude);
            this.setPostalCode(model.postalCode);
            this.setRegion(model.region);
        }

        public final String getCity() {
            return this.city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        public final String getCountry() {
            return this.country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        public final Double getLatitude() {
            return this.latitude;
        }

        @Override
        public final Builder latitude(Double latitude) {
            this.latitude = latitude;
            return this;
        }

        public final void setLatitude(Double latitude) {
            this.latitude = latitude;
        }

        public final Double getLongitude() {
            return this.longitude;
        }

        @Override
        public final Builder longitude(Double longitude) {
            this.longitude = longitude;
            return this;
        }

        public final void setLongitude(Double longitude) {
            this.longitude = longitude;
        }

        public final String getPostalCode() {
            return this.postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public EndpointLocation build() {
            return new EndpointLocation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EndpointLocation> {
        public Builder city(String var1);

        public Builder country(String var1);

        public Builder latitude(Double var1);

        public Builder longitude(Double var1);

        public Builder postalCode(String var1);

        public Builder region(String var1);
    }
}

