/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.transform.EmailChannelRequestMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EmailChannelRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, EmailChannelRequest> {
    private final Boolean enabled;
    private final String fromAddress;
    private final String identity;
    private final String roleArn;

    private EmailChannelRequest(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.fromAddress = builder.fromAddress;
        this.identity = builder.identity;
        this.roleArn = builder.roleArn;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public String fromAddress() {
        return this.fromAddress;
    }

    public String identity() {
        return this.identity;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.enabled() == null ? 0 : this.enabled().hashCode());
        hashCode = 31 * hashCode + (this.fromAddress() == null ? 0 : this.fromAddress().hashCode());
        hashCode = 31 * hashCode + (this.identity() == null ? 0 : this.identity().hashCode());
        hashCode = 31 * hashCode + (this.roleArn() == null ? 0 : this.roleArn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailChannelRequest)) {
            return false;
        }
        EmailChannelRequest other = (EmailChannelRequest)obj;
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.fromAddress() == null ^ this.fromAddress() == null) {
            return false;
        }
        if (other.fromAddress() != null && !other.fromAddress().equals(this.fromAddress())) {
            return false;
        }
        if (other.identity() == null ^ this.identity() == null) {
            return false;
        }
        if (other.identity() != null && !other.identity().equals(this.identity())) {
            return false;
        }
        if (other.roleArn() == null ^ this.roleArn() == null) {
            return false;
        }
        return other.roleArn() == null || other.roleArn().equals(this.roleArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.fromAddress() != null) {
            sb.append("FromAddress: ").append(this.fromAddress()).append(",");
        }
        if (this.identity() != null) {
            sb.append("Identity: ").append(this.identity()).append(",");
        }
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EmailChannelRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String fromAddress;
        private String identity;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailChannelRequest model) {
            this.setEnabled(model.enabled);
            this.setFromAddress(model.fromAddress);
            this.setIdentity(model.identity);
            this.setRoleArn(model.roleArn);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getFromAddress() {
            return this.fromAddress;
        }

        @Override
        public final Builder fromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
            return this;
        }

        public final void setFromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
        }

        public final String getIdentity() {
            return this.identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public EmailChannelRequest build() {
            return new EmailChannelRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EmailChannelRequest> {
        public Builder enabled(Boolean var1);

        public Builder fromAddress(String var1);

        public Builder identity(String var1);

        public Builder roleArn(String var1);
    }
}

