/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.Action;
import software.amazon.awssdk.services.pinpoint.model.MapOfListOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.transform.DefaultPushNotificationMessageMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DefaultPushNotificationMessage
implements StructuredPojo,
ToCopyableBuilder<Builder, DefaultPushNotificationMessage> {
    private final String action;
    private final String body;
    private final Map<String, String> data;
    private final Boolean silentPush;
    private final Map<String, List<String>> substitutions;
    private final String title;
    private final String url;

    private DefaultPushNotificationMessage(BuilderImpl builder) {
        this.action = builder.action;
        this.body = builder.body;
        this.data = builder.data;
        this.silentPush = builder.silentPush;
        this.substitutions = builder.substitutions;
        this.title = builder.title;
        this.url = builder.url;
    }

    public String action() {
        return this.action;
    }

    public String body() {
        return this.body;
    }

    public Map<String, String> data() {
        return this.data;
    }

    public Boolean silentPush() {
        return this.silentPush;
    }

    public Map<String, List<String>> substitutions() {
        return this.substitutions;
    }

    public String title() {
        return this.title;
    }

    public String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.action() == null ? 0 : this.action().hashCode());
        hashCode = 31 * hashCode + (this.body() == null ? 0 : this.body().hashCode());
        hashCode = 31 * hashCode + (this.data() == null ? 0 : this.data().hashCode());
        hashCode = 31 * hashCode + (this.silentPush() == null ? 0 : this.silentPush().hashCode());
        hashCode = 31 * hashCode + (this.substitutions() == null ? 0 : this.substitutions().hashCode());
        hashCode = 31 * hashCode + (this.title() == null ? 0 : this.title().hashCode());
        hashCode = 31 * hashCode + (this.url() == null ? 0 : this.url().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultPushNotificationMessage)) {
            return false;
        }
        DefaultPushNotificationMessage other = (DefaultPushNotificationMessage)obj;
        if (other.action() == null ^ this.action() == null) {
            return false;
        }
        if (other.action() != null && !other.action().equals(this.action())) {
            return false;
        }
        if (other.body() == null ^ this.body() == null) {
            return false;
        }
        if (other.body() != null && !other.body().equals(this.body())) {
            return false;
        }
        if (other.data() == null ^ this.data() == null) {
            return false;
        }
        if (other.data() != null && !other.data().equals(this.data())) {
            return false;
        }
        if (other.silentPush() == null ^ this.silentPush() == null) {
            return false;
        }
        if (other.silentPush() != null && !other.silentPush().equals(this.silentPush())) {
            return false;
        }
        if (other.substitutions() == null ^ this.substitutions() == null) {
            return false;
        }
        if (other.substitutions() != null && !other.substitutions().equals(this.substitutions())) {
            return false;
        }
        if (other.title() == null ^ this.title() == null) {
            return false;
        }
        if (other.title() != null && !other.title().equals(this.title())) {
            return false;
        }
        if (other.url() == null ^ this.url() == null) {
            return false;
        }
        return other.url() == null || other.url().equals(this.url());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.action() != null) {
            sb.append("Action: ").append(this.action()).append(",");
        }
        if (this.body() != null) {
            sb.append("Body: ").append(this.body()).append(",");
        }
        if (this.data() != null) {
            sb.append("Data: ").append(this.data()).append(",");
        }
        if (this.silentPush() != null) {
            sb.append("SilentPush: ").append(this.silentPush()).append(",");
        }
        if (this.substitutions() != null) {
            sb.append("Substitutions: ").append(this.substitutions()).append(",");
        }
        if (this.title() != null) {
            sb.append("Title: ").append(this.title()).append(",");
        }
        if (this.url() != null) {
            sb.append("Url: ").append(this.url()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DefaultPushNotificationMessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String action;
        private String body;
        private Map<String, String> data;
        private Boolean silentPush;
        private Map<String, List<String>> substitutions;
        private String title;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultPushNotificationMessage model) {
            this.setAction(model.action);
            this.setBody(model.body);
            this.setData(model.data);
            this.setSilentPush(model.silentPush);
            this.setSubstitutions(model.substitutions);
            this.setTitle(model.title);
            this.setUrl(model.url);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(Action action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final void setAction(Action action) {
            this.action(action.toString());
        }

        public final String getBody() {
            return this.body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final Map<String, String> getData() {
            return this.data;
        }

        @Override
        public final Builder data(Map<String, String> data) {
            this.data = MapOf__stringCopier.copy(data);
            return this;
        }

        public final void setData(Map<String, String> data) {
            this.data = MapOf__stringCopier.copy(data);
        }

        public final Boolean getSilentPush() {
            return this.silentPush;
        }

        @Override
        public final Builder silentPush(Boolean silentPush) {
            this.silentPush = silentPush;
            return this;
        }

        public final void setSilentPush(Boolean silentPush) {
            this.silentPush = silentPush;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            return this.substitutions;
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public DefaultPushNotificationMessage build() {
            return new DefaultPushNotificationMessage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DefaultPushNotificationMessage> {
        public Builder action(String var1);

        public Builder action(Action var1);

        public Builder body(String var1);

        public Builder data(Map<String, String> var1);

        public Builder silentPush(Boolean var1);

        public Builder substitutions(Map<String, ? extends Collection<String>> var1);

        public Builder title(String var1);

        public Builder url(String var1);
    }
}

