/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.MessageRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MessageRequestMarshaller {
    private static final MarshallingInfo<Map> ADDRESSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Addresses").isBinary(false).build();
    private static final MarshallingInfo<Map> CONTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Context").isBinary(false).build();
    private static final MarshallingInfo<Map> ENDPOINTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Endpoints").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> MESSAGECONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MessageConfiguration").isBinary(false).build();
    private static final MessageRequestMarshaller INSTANCE = new MessageRequestMarshaller();

    private MessageRequestMarshaller() {
    }

    public static MessageRequestMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MessageRequest messageRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)messageRequest, (String)"messageRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(messageRequest.addresses(), ADDRESSES_BINDING);
            protocolMarshaller.marshall(messageRequest.context(), CONTEXT_BINDING);
            protocolMarshaller.marshall(messageRequest.endpoints(), ENDPOINTS_BINDING);
            protocolMarshaller.marshall((Object)messageRequest.messageConfiguration(), MESSAGECONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

