/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.ImportJobResponse;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ImportJobResponseMarshaller {
    private static final MarshallingInfo<String> APPLICATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationId").isBinary(false).build();
    private static final MarshallingInfo<Integer> COMPLETEDPIECES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompletedPieces").isBinary(false).build();
    private static final MarshallingInfo<String> COMPLETIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompletionDate").isBinary(false).build();
    private static final MarshallingInfo<String> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DEFINITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Definition").isBinary(false).build();
    private static final MarshallingInfo<Integer> FAILEDPIECES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailedPieces").isBinary(false).build();
    private static final MarshallingInfo<List> FAILURES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Failures").isBinary(false).build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> JOBSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobStatus").isBinary(false).build();
    private static final MarshallingInfo<Integer> TOTALFAILURES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalFailures").isBinary(false).build();
    private static final MarshallingInfo<Integer> TOTALPIECES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalPieces").isBinary(false).build();
    private static final MarshallingInfo<Integer> TOTALPROCESSED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalProcessed").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final ImportJobResponseMarshaller INSTANCE = new ImportJobResponseMarshaller();

    private ImportJobResponseMarshaller() {
    }

    public static ImportJobResponseMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ImportJobResponse importJobResponse, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)importJobResponse, (String)"importJobResponse");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)importJobResponse.applicationId(), APPLICATIONID_BINDING);
            protocolMarshaller.marshall((Object)importJobResponse.completedPieces(), COMPLETEDPIECES_BINDING);
            protocolMarshaller.marshall((Object)importJobResponse.completionDate(), COMPLETIONDATE_BINDING);
            protocolMarshaller.marshall((Object)importJobResponse.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)importJobResponse.definition(), DEFINITION_BINDING);
            protocolMarshaller.marshall((Object)importJobResponse.failedPieces(), FAILEDPIECES_BINDING);
            protocolMarshaller.marshall(importJobResponse.failures(), FAILURES_BINDING);
            protocolMarshaller.marshall((Object)importJobResponse.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)importJobResponse.jobStatusAsString(), JOBSTATUS_BINDING);
            protocolMarshaller.marshall((Object)importJobResponse.totalFailures(), TOTALFAILURES_BINDING);
            protocolMarshaller.marshall((Object)importJobResponse.totalPieces(), TOTALPIECES_BINDING);
            protocolMarshaller.marshall((Object)importJobResponse.totalProcessed(), TOTALPROCESSED_BINDING);
            protocolMarshaller.marshall((Object)importJobResponse.type(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

