/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.EndpointSendConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EndpointSendConfigurationMarshaller {
    private static final MarshallingInfo<String> BODYOVERRIDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BodyOverride").isBinary(false).build();
    private static final MarshallingInfo<Map> CONTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Context").isBinary(false).build();
    private static final MarshallingInfo<String> RAWCONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RawContent").isBinary(false).build();
    private static final MarshallingInfo<Map> SUBSTITUTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Substitutions").isBinary(false).build();
    private static final MarshallingInfo<String> TITLEOVERRIDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TitleOverride").isBinary(false).build();
    private static final EndpointSendConfigurationMarshaller INSTANCE = new EndpointSendConfigurationMarshaller();

    private EndpointSendConfigurationMarshaller() {
    }

    public static EndpointSendConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EndpointSendConfiguration endpointSendConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)endpointSendConfiguration, (String)"endpointSendConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)endpointSendConfiguration.bodyOverride(), BODYOVERRIDE_BINDING);
            protocolMarshaller.marshall(endpointSendConfiguration.context(), CONTEXT_BINDING);
            protocolMarshaller.marshall((Object)endpointSendConfiguration.rawContent(), RAWCONTENT_BINDING);
            protocolMarshaller.marshall(endpointSendConfiguration.substitutions(), SUBSTITUTIONS_BINDING);
            protocolMarshaller.marshall((Object)endpointSendConfiguration.titleOverride(), TITLEOVERRIDE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

