/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.EmailChannelRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EmailChannelRequestMarshaller {
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").isBinary(false).build();
    private static final MarshallingInfo<String> FROMADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FromAddress").isBinary(false).build();
    private static final MarshallingInfo<String> IDENTITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Identity").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").isBinary(false).build();
    private static final EmailChannelRequestMarshaller INSTANCE = new EmailChannelRequestMarshaller();

    private EmailChannelRequestMarshaller() {
    }

    public static EmailChannelRequestMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EmailChannelRequest emailChannelRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)emailChannelRequest, (String)"emailChannelRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)emailChannelRequest.enabled(), ENABLED_BINDING);
            protocolMarshaller.marshall((Object)emailChannelRequest.fromAddress(), FROMADDRESS_BINDING);
            protocolMarshaller.marshall((Object)emailChannelRequest.identity(), IDENTITY_BINDING);
            protocolMarshaller.marshall((Object)emailChannelRequest.roleArn(), ROLEARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

