/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.DefaultMessage;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DefaultMessageMarshaller {
    private static final MarshallingInfo<String> BODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Body").isBinary(false).build();
    private static final MarshallingInfo<Map> SUBSTITUTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Substitutions").isBinary(false).build();
    private static final DefaultMessageMarshaller INSTANCE = new DefaultMessageMarshaller();

    private DefaultMessageMarshaller() {
    }

    public static DefaultMessageMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DefaultMessage defaultMessage, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)defaultMessage, (String)"defaultMessage");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)defaultMessage.body(), BODY_BINDING);
            protocolMarshaller.marshall(defaultMessage.substitutions(), SUBSTITUTIONS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

