/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.CampaignSmsMessage;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CampaignSmsMessageMarshaller {
    private static final MarshallingInfo<String> BODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Body").isBinary(false).build();
    private static final MarshallingInfo<String> MESSAGETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MessageType").isBinary(false).build();
    private static final MarshallingInfo<String> SENDERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SenderId").isBinary(false).build();
    private static final CampaignSmsMessageMarshaller INSTANCE = new CampaignSmsMessageMarshaller();

    private CampaignSmsMessageMarshaller() {
    }

    public static CampaignSmsMessageMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CampaignSmsMessage campaignSmsMessage, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)campaignSmsMessage, (String)"campaignSmsMessage");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)campaignSmsMessage.body(), BODY_BINDING);
            protocolMarshaller.marshall((Object)campaignSmsMessage.messageTypeAsString(), MESSAGETYPE_BINDING);
            protocolMarshaller.marshall((Object)campaignSmsMessage.senderId(), SENDERID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

