/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.transform.WriteEventStreamMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WriteEventStream
implements StructuredPojo,
ToCopyableBuilder<Builder, WriteEventStream> {
    private final String destinationStreamArn;
    private final String roleArn;

    private WriteEventStream(BuilderImpl builder) {
        this.destinationStreamArn = builder.destinationStreamArn;
        this.roleArn = builder.roleArn;
    }

    public String destinationStreamArn() {
        return this.destinationStreamArn;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationStreamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteEventStream)) {
            return false;
        }
        WriteEventStream other = (WriteEventStream)obj;
        return Objects.equals(this.destinationStreamArn(), other.destinationStreamArn()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public String toString() {
        return ToString.builder((String)"WriteEventStream").add("DestinationStreamArn", (Object)this.destinationStreamArn()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationStreamArn": {
                return Optional.ofNullable(clazz.cast(this.destinationStreamArn()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WriteEventStreamMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationStreamArn;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(WriteEventStream model) {
            this.destinationStreamArn(model.destinationStreamArn);
            this.roleArn(model.roleArn);
        }

        public final String getDestinationStreamArn() {
            return this.destinationStreamArn;
        }

        @Override
        public final Builder destinationStreamArn(String destinationStreamArn) {
            this.destinationStreamArn = destinationStreamArn;
            return this;
        }

        public final void setDestinationStreamArn(String destinationStreamArn) {
            this.destinationStreamArn = destinationStreamArn;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public WriteEventStream build() {
            return new WriteEventStream(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WriteEventStream> {
        public Builder destinationStreamArn(String var1);

        public Builder roleArn(String var1);
    }
}

