/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.pinpoint.model.GCMChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGcmChannelRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, UpdateGcmChannelRequest> {
    private final String applicationId;
    private final GCMChannelRequest gcmChannelRequest;

    private UpdateGcmChannelRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.gcmChannelRequest = builder.gcmChannelRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public GCMChannelRequest gcmChannelRequest() {
        return this.gcmChannelRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gcmChannelRequest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGcmChannelRequest)) {
            return false;
        }
        UpdateGcmChannelRequest other = (UpdateGcmChannelRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.gcmChannelRequest(), other.gcmChannelRequest());
    }

    public String toString() {
        return ToString.builder((String)"UpdateGcmChannelRequest").add("ApplicationId", (Object)this.applicationId()).add("GCMChannelRequest", (Object)this.gcmChannelRequest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "GCMChannelRequest": {
                return Optional.ofNullable(clazz.cast(this.gcmChannelRequest()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private GCMChannelRequest gcmChannelRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGcmChannelRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.gcmChannelRequest(model.gcmChannelRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final GCMChannelRequest.Builder getGCMChannelRequest() {
            return this.gcmChannelRequest != null ? this.gcmChannelRequest.toBuilder() : null;
        }

        @Override
        public final Builder gcmChannelRequest(GCMChannelRequest gcmChannelRequest) {
            this.gcmChannelRequest = gcmChannelRequest;
            return this;
        }

        public final void setGCMChannelRequest(GCMChannelRequest.BuilderImpl gcmChannelRequest) {
            this.gcmChannelRequest = gcmChannelRequest != null ? gcmChannelRequest.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGcmChannelRequest build() {
            return new UpdateGcmChannelRequest(this);
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    CopyableBuilder<Builder, UpdateGcmChannelRequest> {
        public Builder applicationId(String var1);

        public Builder gcmChannelRequest(GCMChannelRequest var1);

        default public Builder gcmChannelRequest(Consumer<GCMChannelRequest.Builder> gcmChannelRequest) {
            return this.gcmChannelRequest((GCMChannelRequest)((GCMChannelRequest.Builder)GCMChannelRequest.builder().applyMutation(gcmChannelRequest)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

