/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.pinpoint.model.EndpointRequest;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEndpointRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, UpdateEndpointRequest> {
    private final String applicationId;
    private final String endpointId;
    private final EndpointRequest endpointRequest;

    private UpdateEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.endpointId = builder.endpointId;
        this.endpointRequest = builder.endpointRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String endpointId() {
        return this.endpointId;
    }

    public EndpointRequest endpointRequest() {
        return this.endpointRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointRequest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEndpointRequest)) {
            return false;
        }
        UpdateEndpointRequest other = (UpdateEndpointRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.endpointId(), other.endpointId()) && Objects.equals(this.endpointRequest(), other.endpointRequest());
    }

    public String toString() {
        return ToString.builder((String)"UpdateEndpointRequest").add("ApplicationId", (Object)this.applicationId()).add("EndpointId", (Object)this.endpointId()).add("EndpointRequest", (Object)this.endpointRequest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "EndpointId": {
                return Optional.ofNullable(clazz.cast(this.endpointId()));
            }
            case "EndpointRequest": {
                return Optional.ofNullable(clazz.cast(this.endpointRequest()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String endpointId;
        private EndpointRequest endpointRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEndpointRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.endpointId(model.endpointId);
            this.endpointRequest(model.endpointRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getEndpointId() {
            return this.endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        public final EndpointRequest.Builder getEndpointRequest() {
            return this.endpointRequest != null ? this.endpointRequest.toBuilder() : null;
        }

        @Override
        public final Builder endpointRequest(EndpointRequest endpointRequest) {
            this.endpointRequest = endpointRequest;
            return this;
        }

        public final void setEndpointRequest(EndpointRequest.BuilderImpl endpointRequest) {
            this.endpointRequest = endpointRequest != null ? endpointRequest.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEndpointRequest build() {
            return new UpdateEndpointRequest(this);
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    CopyableBuilder<Builder, UpdateEndpointRequest> {
        public Builder applicationId(String var1);

        public Builder endpointId(String var1);

        public Builder endpointRequest(EndpointRequest var1);

        default public Builder endpointRequest(Consumer<EndpointRequest.Builder> endpointRequest) {
            return this.endpointRequest((EndpointRequest)((EndpointRequest.Builder)EndpointRequest.builder().applyMutation(endpointRequest)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

