/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.SetDimension;
import software.amazon.awssdk.services.pinpoint.transform.SegmentDemographicsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SegmentDemographics
implements StructuredPojo,
ToCopyableBuilder<Builder, SegmentDemographics> {
    private final SetDimension appVersion;
    private final SetDimension channel;
    private final SetDimension deviceType;
    private final SetDimension make;
    private final SetDimension model;
    private final SetDimension platform;

    private SegmentDemographics(BuilderImpl builder) {
        this.appVersion = builder.appVersion;
        this.channel = builder.channel;
        this.deviceType = builder.deviceType;
        this.make = builder.make;
        this.model = builder.model;
        this.platform = builder.platform;
    }

    public SetDimension appVersion() {
        return this.appVersion;
    }

    public SetDimension channel() {
        return this.channel;
    }

    public SetDimension deviceType() {
        return this.deviceType;
    }

    public SetDimension make() {
        return this.make;
    }

    public SetDimension model() {
        return this.model;
    }

    public SetDimension platform() {
        return this.platform;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.channel());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.make());
        hashCode = 31 * hashCode + Objects.hashCode(this.model());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentDemographics)) {
            return false;
        }
        SegmentDemographics other = (SegmentDemographics)obj;
        return Objects.equals(this.appVersion(), other.appVersion()) && Objects.equals(this.channel(), other.channel()) && Objects.equals(this.deviceType(), other.deviceType()) && Objects.equals(this.make(), other.make()) && Objects.equals(this.model(), other.model()) && Objects.equals(this.platform(), other.platform());
    }

    public String toString() {
        return ToString.builder((String)"SegmentDemographics").add("AppVersion", (Object)this.appVersion()).add("Channel", (Object)this.channel()).add("DeviceType", (Object)this.deviceType()).add("Make", (Object)this.make()).add("Model", (Object)this.model()).add("Platform", (Object)this.platform()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppVersion": {
                return Optional.ofNullable(clazz.cast(this.appVersion()));
            }
            case "Channel": {
                return Optional.ofNullable(clazz.cast(this.channel()));
            }
            case "DeviceType": {
                return Optional.ofNullable(clazz.cast(this.deviceType()));
            }
            case "Make": {
                return Optional.ofNullable(clazz.cast(this.make()));
            }
            case "Model": {
                return Optional.ofNullable(clazz.cast(this.model()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SegmentDemographicsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private SetDimension appVersion;
        private SetDimension channel;
        private SetDimension deviceType;
        private SetDimension make;
        private SetDimension model;
        private SetDimension platform;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentDemographics model) {
            this.appVersion(model.appVersion);
            this.channel(model.channel);
            this.deviceType(model.deviceType);
            this.make(model.make);
            this.model(model.model);
            this.platform(model.platform);
        }

        public final SetDimension.Builder getAppVersion() {
            return this.appVersion != null ? this.appVersion.toBuilder() : null;
        }

        @Override
        public final Builder appVersion(SetDimension appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final void setAppVersion(SetDimension.BuilderImpl appVersion) {
            this.appVersion = appVersion != null ? appVersion.build() : null;
        }

        public final SetDimension.Builder getChannel() {
            return this.channel != null ? this.channel.toBuilder() : null;
        }

        @Override
        public final Builder channel(SetDimension channel) {
            this.channel = channel;
            return this;
        }

        public final void setChannel(SetDimension.BuilderImpl channel) {
            this.channel = channel != null ? channel.build() : null;
        }

        public final SetDimension.Builder getDeviceType() {
            return this.deviceType != null ? this.deviceType.toBuilder() : null;
        }

        @Override
        public final Builder deviceType(SetDimension deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public final void setDeviceType(SetDimension.BuilderImpl deviceType) {
            this.deviceType = deviceType != null ? deviceType.build() : null;
        }

        public final SetDimension.Builder getMake() {
            return this.make != null ? this.make.toBuilder() : null;
        }

        @Override
        public final Builder make(SetDimension make) {
            this.make = make;
            return this;
        }

        public final void setMake(SetDimension.BuilderImpl make) {
            this.make = make != null ? make.build() : null;
        }

        public final SetDimension.Builder getModel() {
            return this.model != null ? this.model.toBuilder() : null;
        }

        @Override
        public final Builder model(SetDimension model) {
            this.model = model;
            return this;
        }

        public final void setModel(SetDimension.BuilderImpl model) {
            this.model = model != null ? model.build() : null;
        }

        public final SetDimension.Builder getPlatform() {
            return this.platform != null ? this.platform.toBuilder() : null;
        }

        @Override
        public final Builder platform(SetDimension platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(SetDimension.BuilderImpl platform) {
            this.platform = platform != null ? platform.build() : null;
        }

        public SegmentDemographics build() {
            return new SegmentDemographics(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SegmentDemographics> {
        public Builder appVersion(SetDimension var1);

        default public Builder appVersion(Consumer<SetDimension.Builder> appVersion) {
            return this.appVersion((SetDimension)((SetDimension.Builder)SetDimension.builder().applyMutation(appVersion)).build());
        }

        public Builder channel(SetDimension var1);

        default public Builder channel(Consumer<SetDimension.Builder> channel) {
            return this.channel((SetDimension)((SetDimension.Builder)SetDimension.builder().applyMutation(channel)).build());
        }

        public Builder deviceType(SetDimension var1);

        default public Builder deviceType(Consumer<SetDimension.Builder> deviceType) {
            return this.deviceType((SetDimension)((SetDimension.Builder)SetDimension.builder().applyMutation(deviceType)).build());
        }

        public Builder make(SetDimension var1);

        default public Builder make(Consumer<SetDimension.Builder> make) {
            return this.make((SetDimension)((SetDimension.Builder)SetDimension.builder().applyMutation(make)).build());
        }

        public Builder model(SetDimension var1);

        default public Builder model(Consumer<SetDimension.Builder> model) {
            return this.model((SetDimension)((SetDimension.Builder)SetDimension.builder().applyMutation(model)).build());
        }

        public Builder platform(SetDimension var1);

        default public Builder platform(Consumer<SetDimension.Builder> platform) {
            return this.platform((SetDimension)((SetDimension.Builder)SetDimension.builder().applyMutation(platform)).build());
        }
    }
}

