/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.CampaignEmailMessage;
import software.amazon.awssdk.services.pinpoint.model.CampaignSmsMessage;
import software.amazon.awssdk.services.pinpoint.model.Message;
import software.amazon.awssdk.services.pinpoint.transform.MessageConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, MessageConfiguration> {
    private final Message admMessage;
    private final Message apnsMessage;
    private final Message baiduMessage;
    private final Message defaultMessage;
    private final CampaignEmailMessage emailMessage;
    private final Message gcmMessage;
    private final CampaignSmsMessage smsMessage;

    private MessageConfiguration(BuilderImpl builder) {
        this.admMessage = builder.admMessage;
        this.apnsMessage = builder.apnsMessage;
        this.baiduMessage = builder.baiduMessage;
        this.defaultMessage = builder.defaultMessage;
        this.emailMessage = builder.emailMessage;
        this.gcmMessage = builder.gcmMessage;
        this.smsMessage = builder.smsMessage;
    }

    public Message admMessage() {
        return this.admMessage;
    }

    public Message apnsMessage() {
        return this.apnsMessage;
    }

    public Message baiduMessage() {
        return this.baiduMessage;
    }

    public Message defaultMessage() {
        return this.defaultMessage;
    }

    public CampaignEmailMessage emailMessage() {
        return this.emailMessage;
    }

    public Message gcmMessage() {
        return this.gcmMessage;
    }

    public CampaignSmsMessage smsMessage() {
        return this.smsMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.admMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.apnsMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.baiduMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.gcmMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.smsMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageConfiguration)) {
            return false;
        }
        MessageConfiguration other = (MessageConfiguration)obj;
        return Objects.equals(this.admMessage(), other.admMessage()) && Objects.equals(this.apnsMessage(), other.apnsMessage()) && Objects.equals(this.baiduMessage(), other.baiduMessage()) && Objects.equals(this.defaultMessage(), other.defaultMessage()) && Objects.equals(this.emailMessage(), other.emailMessage()) && Objects.equals(this.gcmMessage(), other.gcmMessage()) && Objects.equals(this.smsMessage(), other.smsMessage());
    }

    public String toString() {
        return ToString.builder((String)"MessageConfiguration").add("ADMMessage", (Object)this.admMessage()).add("APNSMessage", (Object)this.apnsMessage()).add("BaiduMessage", (Object)this.baiduMessage()).add("DefaultMessage", (Object)this.defaultMessage()).add("EmailMessage", (Object)this.emailMessage()).add("GCMMessage", (Object)this.gcmMessage()).add("SMSMessage", (Object)this.smsMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ADMMessage": {
                return Optional.ofNullable(clazz.cast(this.admMessage()));
            }
            case "APNSMessage": {
                return Optional.ofNullable(clazz.cast(this.apnsMessage()));
            }
            case "BaiduMessage": {
                return Optional.ofNullable(clazz.cast(this.baiduMessage()));
            }
            case "DefaultMessage": {
                return Optional.ofNullable(clazz.cast(this.defaultMessage()));
            }
            case "EmailMessage": {
                return Optional.ofNullable(clazz.cast(this.emailMessage()));
            }
            case "GCMMessage": {
                return Optional.ofNullable(clazz.cast(this.gcmMessage()));
            }
            case "SMSMessage": {
                return Optional.ofNullable(clazz.cast(this.smsMessage()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MessageConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Message admMessage;
        private Message apnsMessage;
        private Message baiduMessage;
        private Message defaultMessage;
        private CampaignEmailMessage emailMessage;
        private Message gcmMessage;
        private CampaignSmsMessage smsMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageConfiguration model) {
            this.admMessage(model.admMessage);
            this.apnsMessage(model.apnsMessage);
            this.baiduMessage(model.baiduMessage);
            this.defaultMessage(model.defaultMessage);
            this.emailMessage(model.emailMessage);
            this.gcmMessage(model.gcmMessage);
            this.smsMessage(model.smsMessage);
        }

        public final Message.Builder getADMMessage() {
            return this.admMessage != null ? this.admMessage.toBuilder() : null;
        }

        @Override
        public final Builder admMessage(Message admMessage) {
            this.admMessage = admMessage;
            return this;
        }

        public final void setADMMessage(Message.BuilderImpl admMessage) {
            this.admMessage = admMessage != null ? admMessage.build() : null;
        }

        public final Message.Builder getAPNSMessage() {
            return this.apnsMessage != null ? this.apnsMessage.toBuilder() : null;
        }

        @Override
        public final Builder apnsMessage(Message apnsMessage) {
            this.apnsMessage = apnsMessage;
            return this;
        }

        public final void setAPNSMessage(Message.BuilderImpl apnsMessage) {
            this.apnsMessage = apnsMessage != null ? apnsMessage.build() : null;
        }

        public final Message.Builder getBaiduMessage() {
            return this.baiduMessage != null ? this.baiduMessage.toBuilder() : null;
        }

        @Override
        public final Builder baiduMessage(Message baiduMessage) {
            this.baiduMessage = baiduMessage;
            return this;
        }

        public final void setBaiduMessage(Message.BuilderImpl baiduMessage) {
            this.baiduMessage = baiduMessage != null ? baiduMessage.build() : null;
        }

        public final Message.Builder getDefaultMessage() {
            return this.defaultMessage != null ? this.defaultMessage.toBuilder() : null;
        }

        @Override
        public final Builder defaultMessage(Message defaultMessage) {
            this.defaultMessage = defaultMessage;
            return this;
        }

        public final void setDefaultMessage(Message.BuilderImpl defaultMessage) {
            this.defaultMessage = defaultMessage != null ? defaultMessage.build() : null;
        }

        public final CampaignEmailMessage.Builder getEmailMessage() {
            return this.emailMessage != null ? this.emailMessage.toBuilder() : null;
        }

        @Override
        public final Builder emailMessage(CampaignEmailMessage emailMessage) {
            this.emailMessage = emailMessage;
            return this;
        }

        public final void setEmailMessage(CampaignEmailMessage.BuilderImpl emailMessage) {
            this.emailMessage = emailMessage != null ? emailMessage.build() : null;
        }

        public final Message.Builder getGCMMessage() {
            return this.gcmMessage != null ? this.gcmMessage.toBuilder() : null;
        }

        @Override
        public final Builder gcmMessage(Message gcmMessage) {
            this.gcmMessage = gcmMessage;
            return this;
        }

        public final void setGCMMessage(Message.BuilderImpl gcmMessage) {
            this.gcmMessage = gcmMessage != null ? gcmMessage.build() : null;
        }

        public final CampaignSmsMessage.Builder getSMSMessage() {
            return this.smsMessage != null ? this.smsMessage.toBuilder() : null;
        }

        @Override
        public final Builder smsMessage(CampaignSmsMessage smsMessage) {
            this.smsMessage = smsMessage;
            return this;
        }

        public final void setSMSMessage(CampaignSmsMessage.BuilderImpl smsMessage) {
            this.smsMessage = smsMessage != null ? smsMessage.build() : null;
        }

        public MessageConfiguration build() {
            return new MessageConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MessageConfiguration> {
        public Builder admMessage(Message var1);

        default public Builder admMessage(Consumer<Message.Builder> admMessage) {
            return this.admMessage((Message)((Message.Builder)Message.builder().applyMutation(admMessage)).build());
        }

        public Builder apnsMessage(Message var1);

        default public Builder apnsMessage(Consumer<Message.Builder> apnsMessage) {
            return this.apnsMessage((Message)((Message.Builder)Message.builder().applyMutation(apnsMessage)).build());
        }

        public Builder baiduMessage(Message var1);

        default public Builder baiduMessage(Consumer<Message.Builder> baiduMessage) {
            return this.baiduMessage((Message)((Message.Builder)Message.builder().applyMutation(baiduMessage)).build());
        }

        public Builder defaultMessage(Message var1);

        default public Builder defaultMessage(Consumer<Message.Builder> defaultMessage) {
            return this.defaultMessage((Message)((Message.Builder)Message.builder().applyMutation(defaultMessage)).build());
        }

        public Builder emailMessage(CampaignEmailMessage var1);

        default public Builder emailMessage(Consumer<CampaignEmailMessage.Builder> emailMessage) {
            return this.emailMessage((CampaignEmailMessage)((CampaignEmailMessage.Builder)CampaignEmailMessage.builder().applyMutation(emailMessage)).build());
        }

        public Builder gcmMessage(Message var1);

        default public Builder gcmMessage(Consumer<Message.Builder> gcmMessage) {
            return this.gcmMessage((Message)((Message.Builder)Message.builder().applyMutation(gcmMessage)).build());
        }

        public Builder smsMessage(CampaignSmsMessage var1);

        default public Builder smsMessage(Consumer<CampaignSmsMessage.Builder> smsMessage) {
            return this.smsMessage((CampaignSmsMessage)((CampaignSmsMessage.Builder)CampaignSmsMessage.builder().applyMutation(smsMessage)).build());
        }
    }
}

