/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.services.pinpoint.model.WriteSegmentRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSegmentRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, CreateSegmentRequest> {
    private final String applicationId;
    private final WriteSegmentRequest writeSegmentRequest;

    private CreateSegmentRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.writeSegmentRequest = builder.writeSegmentRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public WriteSegmentRequest writeSegmentRequest() {
        return this.writeSegmentRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeSegmentRequest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSegmentRequest)) {
            return false;
        }
        CreateSegmentRequest other = (CreateSegmentRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.writeSegmentRequest(), other.writeSegmentRequest());
    }

    public String toString() {
        return ToString.builder((String)"CreateSegmentRequest").add("ApplicationId", (Object)this.applicationId()).add("WriteSegmentRequest", (Object)this.writeSegmentRequest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "WriteSegmentRequest": {
                return Optional.ofNullable(clazz.cast(this.writeSegmentRequest()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private WriteSegmentRequest writeSegmentRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSegmentRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.writeSegmentRequest(model.writeSegmentRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final WriteSegmentRequest.Builder getWriteSegmentRequest() {
            return this.writeSegmentRequest != null ? this.writeSegmentRequest.toBuilder() : null;
        }

        @Override
        public final Builder writeSegmentRequest(WriteSegmentRequest writeSegmentRequest) {
            this.writeSegmentRequest = writeSegmentRequest;
            return this;
        }

        public final void setWriteSegmentRequest(WriteSegmentRequest.BuilderImpl writeSegmentRequest) {
            this.writeSegmentRequest = writeSegmentRequest != null ? writeSegmentRequest.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSegmentRequest build() {
            return new CreateSegmentRequest(this);
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    CopyableBuilder<Builder, CreateSegmentRequest> {
        public Builder applicationId(String var1);

        public Builder writeSegmentRequest(WriteSegmentRequest var1);

        default public Builder writeSegmentRequest(Consumer<WriteSegmentRequest.Builder> writeSegmentRequest) {
            return this.writeSegmentRequest((WriteSegmentRequest)((WriteSegmentRequest.Builder)WriteSegmentRequest.builder().applyMutation(writeSegmentRequest)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

