/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.MessageType;
import software.amazon.awssdk.services.pinpoint.transform.CampaignSmsMessageMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CampaignSmsMessage
implements StructuredPojo,
ToCopyableBuilder<Builder, CampaignSmsMessage> {
    private final String body;
    private final String messageType;
    private final String senderId;

    private CampaignSmsMessage(BuilderImpl builder) {
        this.body = builder.body;
        this.messageType = builder.messageType;
        this.senderId = builder.senderId;
    }

    public String body() {
        return this.body;
    }

    public MessageType messageType() {
        return MessageType.fromValue(this.messageType);
    }

    public String messageTypeAsString() {
        return this.messageType;
    }

    public String senderId() {
        return this.senderId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.senderId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignSmsMessage)) {
            return false;
        }
        CampaignSmsMessage other = (CampaignSmsMessage)obj;
        return Objects.equals(this.body(), other.body()) && Objects.equals(this.messageTypeAsString(), other.messageTypeAsString()) && Objects.equals(this.senderId(), other.senderId());
    }

    public String toString() {
        return ToString.builder((String)"CampaignSmsMessage").add("Body", (Object)this.body()).add("MessageType", (Object)this.messageTypeAsString()).add("SenderId", (Object)this.senderId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "MessageType": {
                return Optional.ofNullable(clazz.cast(this.messageTypeAsString()));
            }
            case "SenderId": {
                return Optional.ofNullable(clazz.cast(this.senderId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CampaignSmsMessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String body;
        private String messageType;
        private String senderId;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignSmsMessage model) {
            this.body(model.body);
            this.messageType(model.messageType);
            this.senderId(model.senderId);
        }

        public final String getBody() {
            return this.body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final String getMessageType() {
            return this.messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType.toString());
            return this;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        public final String getSenderId() {
            return this.senderId;
        }

        @Override
        public final Builder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        public final void setSenderId(String senderId) {
            this.senderId = senderId;
        }

        public CampaignSmsMessage build() {
            return new CampaignSmsMessage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CampaignSmsMessage> {
        public Builder body(String var1);

        public Builder messageType(String var1);

        public Builder messageType(MessageType var1);

        public Builder senderId(String var1);
    }
}

