/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.pinpoint.model.CampaignLimits;
import software.amazon.awssdk.services.pinpoint.model.CampaignState;
import software.amazon.awssdk.services.pinpoint.model.ListOfTreatmentResourceCopier;
import software.amazon.awssdk.services.pinpoint.model.MessageConfiguration;
import software.amazon.awssdk.services.pinpoint.model.Schedule;
import software.amazon.awssdk.services.pinpoint.model.TreatmentResource;
import software.amazon.awssdk.services.pinpoint.transform.CampaignResponseMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CampaignResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, CampaignResponse> {
    private final List<TreatmentResource> additionalTreatments;
    private final String applicationId;
    private final String creationDate;
    private final CampaignState defaultState;
    private final String description;
    private final Integer holdoutPercent;
    private final String id;
    private final Boolean isPaused;
    private final String lastModifiedDate;
    private final CampaignLimits limits;
    private final MessageConfiguration messageConfiguration;
    private final String name;
    private final Schedule schedule;
    private final String segmentId;
    private final Integer segmentVersion;
    private final CampaignState state;
    private final String treatmentDescription;
    private final String treatmentName;
    private final Integer version;

    private CampaignResponse(BuilderImpl builder) {
        this.additionalTreatments = builder.additionalTreatments;
        this.applicationId = builder.applicationId;
        this.creationDate = builder.creationDate;
        this.defaultState = builder.defaultState;
        this.description = builder.description;
        this.holdoutPercent = builder.holdoutPercent;
        this.id = builder.id;
        this.isPaused = builder.isPaused;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.limits = builder.limits;
        this.messageConfiguration = builder.messageConfiguration;
        this.name = builder.name;
        this.schedule = builder.schedule;
        this.segmentId = builder.segmentId;
        this.segmentVersion = builder.segmentVersion;
        this.state = builder.state;
        this.treatmentDescription = builder.treatmentDescription;
        this.treatmentName = builder.treatmentName;
        this.version = builder.version;
    }

    public List<TreatmentResource> additionalTreatments() {
        return this.additionalTreatments;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String creationDate() {
        return this.creationDate;
    }

    public CampaignState defaultState() {
        return this.defaultState;
    }

    public String description() {
        return this.description;
    }

    public Integer holdoutPercent() {
        return this.holdoutPercent;
    }

    public String id() {
        return this.id;
    }

    public Boolean isPaused() {
        return this.isPaused;
    }

    public String lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public CampaignLimits limits() {
        return this.limits;
    }

    public MessageConfiguration messageConfiguration() {
        return this.messageConfiguration;
    }

    public String name() {
        return this.name;
    }

    public Schedule schedule() {
        return this.schedule;
    }

    public String segmentId() {
        return this.segmentId;
    }

    public Integer segmentVersion() {
        return this.segmentVersion;
    }

    public CampaignState state() {
        return this.state;
    }

    public String treatmentDescription() {
        return this.treatmentDescription;
    }

    public String treatmentName() {
        return this.treatmentName;
    }

    public Integer version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalTreatments());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultState());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.holdoutPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.isPaused());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.limits());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.treatmentDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.treatmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignResponse)) {
            return false;
        }
        CampaignResponse other = (CampaignResponse)obj;
        return Objects.equals(this.additionalTreatments(), other.additionalTreatments()) && Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.defaultState(), other.defaultState()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.holdoutPercent(), other.holdoutPercent()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.isPaused(), other.isPaused()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.limits(), other.limits()) && Objects.equals(this.messageConfiguration(), other.messageConfiguration()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.segmentId(), other.segmentId()) && Objects.equals(this.segmentVersion(), other.segmentVersion()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.treatmentDescription(), other.treatmentDescription()) && Objects.equals(this.treatmentName(), other.treatmentName()) && Objects.equals(this.version(), other.version());
    }

    public String toString() {
        return ToString.builder((String)"CampaignResponse").add("AdditionalTreatments", this.additionalTreatments()).add("ApplicationId", (Object)this.applicationId()).add("CreationDate", (Object)this.creationDate()).add("DefaultState", (Object)this.defaultState()).add("Description", (Object)this.description()).add("HoldoutPercent", (Object)this.holdoutPercent()).add("Id", (Object)this.id()).add("IsPaused", (Object)this.isPaused()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("Limits", (Object)this.limits()).add("MessageConfiguration", (Object)this.messageConfiguration()).add("Name", (Object)this.name()).add("Schedule", (Object)this.schedule()).add("SegmentId", (Object)this.segmentId()).add("SegmentVersion", (Object)this.segmentVersion()).add("State", (Object)this.state()).add("TreatmentDescription", (Object)this.treatmentDescription()).add("TreatmentName", (Object)this.treatmentName()).add("Version", (Object)this.version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdditionalTreatments": {
                return Optional.ofNullable(clazz.cast(this.additionalTreatments()));
            }
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "DefaultState": {
                return Optional.ofNullable(clazz.cast(this.defaultState()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "HoldoutPercent": {
                return Optional.ofNullable(clazz.cast(this.holdoutPercent()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "IsPaused": {
                return Optional.ofNullable(clazz.cast(this.isPaused()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "Limits": {
                return Optional.ofNullable(clazz.cast(this.limits()));
            }
            case "MessageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.messageConfiguration()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "SegmentId": {
                return Optional.ofNullable(clazz.cast(this.segmentId()));
            }
            case "SegmentVersion": {
                return Optional.ofNullable(clazz.cast(this.segmentVersion()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "TreatmentDescription": {
                return Optional.ofNullable(clazz.cast(this.treatmentDescription()));
            }
            case "TreatmentName": {
                return Optional.ofNullable(clazz.cast(this.treatmentName()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CampaignResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<TreatmentResource> additionalTreatments = DefaultSdkAutoConstructList.getInstance();
        private String applicationId;
        private String creationDate;
        private CampaignState defaultState;
        private String description;
        private Integer holdoutPercent;
        private String id;
        private Boolean isPaused;
        private String lastModifiedDate;
        private CampaignLimits limits;
        private MessageConfiguration messageConfiguration;
        private String name;
        private Schedule schedule;
        private String segmentId;
        private Integer segmentVersion;
        private CampaignState state;
        private String treatmentDescription;
        private String treatmentName;
        private Integer version;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignResponse model) {
            this.additionalTreatments(model.additionalTreatments);
            this.applicationId(model.applicationId);
            this.creationDate(model.creationDate);
            this.defaultState(model.defaultState);
            this.description(model.description);
            this.holdoutPercent(model.holdoutPercent);
            this.id(model.id);
            this.isPaused(model.isPaused);
            this.lastModifiedDate(model.lastModifiedDate);
            this.limits(model.limits);
            this.messageConfiguration(model.messageConfiguration);
            this.name(model.name);
            this.schedule(model.schedule);
            this.segmentId(model.segmentId);
            this.segmentVersion(model.segmentVersion);
            this.state(model.state);
            this.treatmentDescription(model.treatmentDescription);
            this.treatmentName(model.treatmentName);
            this.version(model.version);
        }

        public final Collection<TreatmentResource.Builder> getAdditionalTreatments() {
            return this.additionalTreatments != null ? (Collection)this.additionalTreatments.stream().map(TreatmentResource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder additionalTreatments(Collection<TreatmentResource> additionalTreatments) {
            this.additionalTreatments = ListOfTreatmentResourceCopier.copy(additionalTreatments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalTreatments(TreatmentResource ... additionalTreatments) {
            this.additionalTreatments(Arrays.asList(additionalTreatments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalTreatments(Consumer<TreatmentResource.Builder> ... additionalTreatments) {
            this.additionalTreatments(Stream.of(additionalTreatments).map(c -> (TreatmentResource)((TreatmentResource.Builder)TreatmentResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdditionalTreatments(Collection<TreatmentResource.BuilderImpl> additionalTreatments) {
            this.additionalTreatments = ListOfTreatmentResourceCopier.copyFromBuilder(additionalTreatments);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final CampaignState.Builder getDefaultState() {
            return this.defaultState != null ? this.defaultState.toBuilder() : null;
        }

        @Override
        public final Builder defaultState(CampaignState defaultState) {
            this.defaultState = defaultState;
            return this;
        }

        public final void setDefaultState(CampaignState.BuilderImpl defaultState) {
            this.defaultState = defaultState != null ? defaultState.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getHoldoutPercent() {
            return this.holdoutPercent;
        }

        @Override
        public final Builder holdoutPercent(Integer holdoutPercent) {
            this.holdoutPercent = holdoutPercent;
            return this;
        }

        public final void setHoldoutPercent(Integer holdoutPercent) {
            this.holdoutPercent = holdoutPercent;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Boolean getIsPaused() {
            return this.isPaused;
        }

        @Override
        public final Builder isPaused(Boolean isPaused) {
            this.isPaused = isPaused;
            return this;
        }

        public final void setIsPaused(Boolean isPaused) {
            this.isPaused = isPaused;
        }

        public final String getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final CampaignLimits.Builder getLimits() {
            return this.limits != null ? this.limits.toBuilder() : null;
        }

        @Override
        public final Builder limits(CampaignLimits limits) {
            this.limits = limits;
            return this;
        }

        public final void setLimits(CampaignLimits.BuilderImpl limits) {
            this.limits = limits != null ? limits.build() : null;
        }

        public final MessageConfiguration.Builder getMessageConfiguration() {
            return this.messageConfiguration != null ? this.messageConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder messageConfiguration(MessageConfiguration messageConfiguration) {
            this.messageConfiguration = messageConfiguration;
            return this;
        }

        public final void setMessageConfiguration(MessageConfiguration.BuilderImpl messageConfiguration) {
            this.messageConfiguration = messageConfiguration != null ? messageConfiguration.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Schedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        public final String getSegmentId() {
            return this.segmentId;
        }

        @Override
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        public final Integer getSegmentVersion() {
            return this.segmentVersion;
        }

        @Override
        public final Builder segmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
            return this;
        }

        public final void setSegmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
        }

        public final CampaignState.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        @Override
        public final Builder state(CampaignState state) {
            this.state = state;
            return this;
        }

        public final void setState(CampaignState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        public final String getTreatmentDescription() {
            return this.treatmentDescription;
        }

        @Override
        public final Builder treatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
            return this;
        }

        public final void setTreatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
        }

        public final String getTreatmentName() {
            return this.treatmentName;
        }

        @Override
        public final Builder treatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
            return this;
        }

        public final void setTreatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
        }

        public final Integer getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        public CampaignResponse build() {
            return new CampaignResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CampaignResponse> {
        public Builder additionalTreatments(Collection<TreatmentResource> var1);

        public Builder additionalTreatments(TreatmentResource ... var1);

        public Builder additionalTreatments(Consumer<TreatmentResource.Builder> ... var1);

        public Builder applicationId(String var1);

        public Builder creationDate(String var1);

        public Builder defaultState(CampaignState var1);

        default public Builder defaultState(Consumer<CampaignState.Builder> defaultState) {
            return this.defaultState((CampaignState)((CampaignState.Builder)CampaignState.builder().applyMutation(defaultState)).build());
        }

        public Builder description(String var1);

        public Builder holdoutPercent(Integer var1);

        public Builder id(String var1);

        public Builder isPaused(Boolean var1);

        public Builder lastModifiedDate(String var1);

        public Builder limits(CampaignLimits var1);

        default public Builder limits(Consumer<CampaignLimits.Builder> limits) {
            return this.limits((CampaignLimits)((CampaignLimits.Builder)CampaignLimits.builder().applyMutation(limits)).build());
        }

        public Builder messageConfiguration(MessageConfiguration var1);

        default public Builder messageConfiguration(Consumer<MessageConfiguration.Builder> messageConfiguration) {
            return this.messageConfiguration((MessageConfiguration)((MessageConfiguration.Builder)MessageConfiguration.builder().applyMutation(messageConfiguration)).build());
        }

        public Builder name(String var1);

        public Builder schedule(Schedule var1);

        default public Builder schedule(Consumer<Schedule.Builder> schedule) {
            return this.schedule((Schedule)((Schedule.Builder)Schedule.builder().applyMutation(schedule)).build());
        }

        public Builder segmentId(String var1);

        public Builder segmentVersion(Integer var1);

        public Builder state(CampaignState var1);

        default public Builder state(Consumer<CampaignState.Builder> state) {
            return this.state((CampaignState)((CampaignState.Builder)CampaignState.builder().applyMutation(state)).build());
        }

        public Builder treatmentDescription(String var1);

        public Builder treatmentName(String var1);

        public Builder version(Integer var1);
    }
}

