/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.pinpoint.model.AttributeType;
import software.amazon.awssdk.services.pinpoint.model.ListOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.transform.AttributeDimensionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttributeDimension
implements StructuredPojo,
ToCopyableBuilder<Builder, AttributeDimension> {
    private final String attributeType;
    private final List<String> values;

    private AttributeDimension(BuilderImpl builder) {
        this.attributeType = builder.attributeType;
        this.values = builder.values;
    }

    public AttributeType attributeType() {
        return AttributeType.fromValue(this.attributeType);
    }

    public String attributeTypeAsString() {
        return this.attributeType;
    }

    public List<String> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.values());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeDimension)) {
            return false;
        }
        AttributeDimension other = (AttributeDimension)obj;
        return Objects.equals(this.attributeTypeAsString(), other.attributeTypeAsString()) && Objects.equals(this.values(), other.values());
    }

    public String toString() {
        return ToString.builder((String)"AttributeDimension").add("AttributeType", (Object)this.attributeTypeAsString()).add("Values", this.values()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeType": {
                return Optional.ofNullable(clazz.cast(this.attributeTypeAsString()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttributeDimensionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String attributeType;
        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeDimension model) {
            this.attributeType(model.attributeType);
            this.values(model.values);
        }

        public final String getAttributeType() {
            return this.attributeType;
        }

        @Override
        public final Builder attributeType(String attributeType) {
            this.attributeType = attributeType;
            return this;
        }

        @Override
        public final Builder attributeType(AttributeType attributeType) {
            this.attributeType(attributeType.toString());
            return this;
        }

        public final void setAttributeType(String attributeType) {
            this.attributeType = attributeType;
        }

        public final Collection<String> getValues() {
            return this.values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ListOf__stringCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = ListOf__stringCopier.copy(values);
        }

        public AttributeDimension build() {
            return new AttributeDimension(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AttributeDimension> {
        public Builder attributeType(String var1);

        public Builder attributeType(AttributeType var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);
    }
}

