/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pi.model.MetricDimensionGroups;
import software.amazon.awssdk.services.pi.model.MetricDimensionsListCopier;
import software.amazon.awssdk.services.pi.model.PiResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAvailableResourceDimensionsResponse
extends PiResponse
implements ToCopyableBuilder<Builder, ListAvailableResourceDimensionsResponse> {
    private static final SdkField<List<MetricDimensionGroups>> METRIC_DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricDimensions").getter(ListAvailableResourceDimensionsResponse.getter(ListAvailableResourceDimensionsResponse::metricDimensions)).setter(ListAvailableResourceDimensionsResponse.setter(Builder::metricDimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDimensionGroups::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAvailableResourceDimensionsResponse.getter(ListAvailableResourceDimensionsResponse::nextToken)).setter(ListAvailableResourceDimensionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_DIMENSIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAvailableResourceDimensionsResponse.memberNameToFieldInitializer();
    private final List<MetricDimensionGroups> metricDimensions;
    private final String nextToken;

    private ListAvailableResourceDimensionsResponse(BuilderImpl builder) {
        super(builder);
        this.metricDimensions = builder.metricDimensions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMetricDimensions() {
        return this.metricDimensions != null && !(this.metricDimensions instanceof SdkAutoConstructList);
    }

    public final List<MetricDimensionGroups> metricDimensions() {
        return this.metricDimensions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricDimensions() ? this.metricDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAvailableResourceDimensionsResponse)) {
            return false;
        }
        ListAvailableResourceDimensionsResponse other = (ListAvailableResourceDimensionsResponse)((Object)obj);
        return this.hasMetricDimensions() == other.hasMetricDimensions() && Objects.equals(this.metricDimensions(), other.metricDimensions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAvailableResourceDimensionsResponse").add("MetricDimensions", this.hasMetricDimensions() ? this.metricDimensions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricDimensions": {
                return Optional.ofNullable(clazz.cast(this.metricDimensions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MetricDimensions", METRIC_DIMENSIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAvailableResourceDimensionsResponse, T> g) {
        return obj -> g.apply((ListAvailableResourceDimensionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PiResponse.BuilderImpl
    implements Builder {
        private List<MetricDimensionGroups> metricDimensions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAvailableResourceDimensionsResponse model) {
            super(model);
            this.metricDimensions(model.metricDimensions);
            this.nextToken(model.nextToken);
        }

        public final List<MetricDimensionGroups.Builder> getMetricDimensions() {
            List<MetricDimensionGroups.Builder> result = MetricDimensionsListCopier.copyToBuilder(this.metricDimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricDimensions(Collection<MetricDimensionGroups.BuilderImpl> metricDimensions) {
            this.metricDimensions = MetricDimensionsListCopier.copyFromBuilder(metricDimensions);
        }

        @Override
        public final Builder metricDimensions(Collection<MetricDimensionGroups> metricDimensions) {
            this.metricDimensions = MetricDimensionsListCopier.copy(metricDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDimensions(MetricDimensionGroups ... metricDimensions) {
            this.metricDimensions(Arrays.asList(metricDimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDimensions(Consumer<MetricDimensionGroups.Builder> ... metricDimensions) {
            this.metricDimensions(Stream.of(metricDimensions).map(c -> (MetricDimensionGroups)((MetricDimensionGroups.Builder)MetricDimensionGroups.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAvailableResourceDimensionsResponse build() {
            return new ListAvailableResourceDimensionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PiResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAvailableResourceDimensionsResponse> {
        public Builder metricDimensions(Collection<MetricDimensionGroups> var1);

        public Builder metricDimensions(MetricDimensionGroups ... var1);

        public Builder metricDimensions(Consumer<MetricDimensionGroups.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

