/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pi.model.AdditionalMetricsMapCopier;
import software.amazon.awssdk.services.pi.model.DimensionMapCopier;
import software.amazon.awssdk.services.pi.model.MetricValuesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DimensionKeyDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DimensionKeyDescription> {
    private static final SdkField<Map<String, String>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Dimensions").getter(DimensionKeyDescription.getter(DimensionKeyDescription::dimensions)).setter(DimensionKeyDescription.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Double> TOTAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Total").getter(DimensionKeyDescription.getter(DimensionKeyDescription::total)).setter(DimensionKeyDescription.setter(Builder::total)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Total").build()}).build();
    private static final SdkField<Map<String, Double>> ADDITIONAL_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AdditionalMetrics").getter(DimensionKeyDescription.getter(DimensionKeyDescription::additionalMetrics)).setter(DimensionKeyDescription.setter(Builder::additionalMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalMetrics").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<Double>> PARTITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Partitions").getter(DimensionKeyDescription.getter(DimensionKeyDescription::partitions)).setter(DimensionKeyDescription.setter(Builder::partitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Partitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD, TOTAL_FIELD, ADDITIONAL_METRICS_FIELD, PARTITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DimensionKeyDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> dimensions;
    private final Double total;
    private final Map<String, Double> additionalMetrics;
    private final List<Double> partitions;

    private DimensionKeyDescription(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.total = builder.total;
        this.additionalMetrics = builder.additionalMetrics;
        this.partitions = builder.partitions;
    }

    public final boolean hasDimensions() {
        return this.dimensions != null && !(this.dimensions instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> dimensions() {
        return this.dimensions;
    }

    public final Double total() {
        return this.total;
    }

    public final boolean hasAdditionalMetrics() {
        return this.additionalMetrics != null && !(this.additionalMetrics instanceof SdkAutoConstructMap);
    }

    public final Map<String, Double> additionalMetrics() {
        return this.additionalMetrics;
    }

    public final boolean hasPartitions() {
        return this.partitions != null && !(this.partitions instanceof SdkAutoConstructList);
    }

    public final List<Double> partitions() {
        return this.partitions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensions() ? this.dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.total());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalMetrics() ? this.additionalMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartitions() ? this.partitions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimensionKeyDescription)) {
            return false;
        }
        DimensionKeyDescription other = (DimensionKeyDescription)obj;
        return this.hasDimensions() == other.hasDimensions() && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.total(), other.total()) && this.hasAdditionalMetrics() == other.hasAdditionalMetrics() && Objects.equals(this.additionalMetrics(), other.additionalMetrics()) && this.hasPartitions() == other.hasPartitions() && Objects.equals(this.partitions(), other.partitions());
    }

    public final String toString() {
        return ToString.builder((String)"DimensionKeyDescription").add("Dimensions", this.hasDimensions() ? this.dimensions() : null).add("Total", (Object)this.total()).add("AdditionalMetrics", this.hasAdditionalMetrics() ? this.additionalMetrics() : null).add("Partitions", this.hasPartitions() ? this.partitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "Total": {
                return Optional.ofNullable(clazz.cast(this.total()));
            }
            case "AdditionalMetrics": {
                return Optional.ofNullable(clazz.cast(this.additionalMetrics()));
            }
            case "Partitions": {
                return Optional.ofNullable(clazz.cast(this.partitions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Dimensions", DIMENSIONS_FIELD);
        map.put("Total", TOTAL_FIELD);
        map.put("AdditionalMetrics", ADDITIONAL_METRICS_FIELD);
        map.put("Partitions", PARTITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DimensionKeyDescription, T> g) {
        return obj -> g.apply((DimensionKeyDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> dimensions = DefaultSdkAutoConstructMap.getInstance();
        private Double total;
        private Map<String, Double> additionalMetrics = DefaultSdkAutoConstructMap.getInstance();
        private List<Double> partitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DimensionKeyDescription model) {
            this.dimensions(model.dimensions);
            this.total(model.total);
            this.additionalMetrics(model.additionalMetrics);
            this.partitions(model.partitions);
        }

        public final Map<String, String> getDimensions() {
            if (this.dimensions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.dimensions;
        }

        public final void setDimensions(Map<String, String> dimensions) {
            this.dimensions = DimensionMapCopier.copy(dimensions);
        }

        @Override
        public final Builder dimensions(Map<String, String> dimensions) {
            this.dimensions = DimensionMapCopier.copy(dimensions);
            return this;
        }

        public final Double getTotal() {
            return this.total;
        }

        public final void setTotal(Double total) {
            this.total = total;
        }

        @Override
        public final Builder total(Double total) {
            this.total = total;
            return this;
        }

        public final Map<String, Double> getAdditionalMetrics() {
            if (this.additionalMetrics instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalMetrics;
        }

        public final void setAdditionalMetrics(Map<String, Double> additionalMetrics) {
            this.additionalMetrics = AdditionalMetricsMapCopier.copy(additionalMetrics);
        }

        @Override
        public final Builder additionalMetrics(Map<String, Double> additionalMetrics) {
            this.additionalMetrics = AdditionalMetricsMapCopier.copy(additionalMetrics);
            return this;
        }

        public final Collection<Double> getPartitions() {
            if (this.partitions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.partitions;
        }

        public final void setPartitions(Collection<Double> partitions) {
            this.partitions = MetricValuesListCopier.copy(partitions);
        }

        @Override
        public final Builder partitions(Collection<Double> partitions) {
            this.partitions = MetricValuesListCopier.copy(partitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitions(Double ... partitions) {
            this.partitions(Arrays.asList(partitions));
            return this;
        }

        public DimensionKeyDescription build() {
            return new DimensionKeyDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DimensionKeyDescription> {
        public Builder dimensions(Map<String, String> var1);

        public Builder total(Double var1);

        public Builder additionalMetrics(Map<String, Double> var1);

        public Builder partitions(Collection<Double> var1);

        public Builder partitions(Double ... var1);
    }
}

