/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pi.model.AnalysisStatus;
import software.amazon.awssdk.services.pi.model.Insight;
import software.amazon.awssdk.services.pi.model.InsightListCopier;
import software.amazon.awssdk.services.pi.model.ServiceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalysisReport
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalysisReport> {
    private static final SdkField<String> ANALYSIS_REPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnalysisReportId").getter(AnalysisReport.getter(AnalysisReport::analysisReportId)).setter(AnalysisReport.setter(Builder::analysisReportId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisReportId").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(AnalysisReport.getter(AnalysisReport::identifier)).setter(AnalysisReport.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()}).build();
    private static final SdkField<String> SERVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceType").getter(AnalysisReport.getter(AnalysisReport::serviceTypeAsString)).setter(AnalysisReport.setter(Builder::serviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceType").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(AnalysisReport.getter(AnalysisReport::createTime)).setter(AnalysisReport.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(AnalysisReport.getter(AnalysisReport::startTime)).setter(AnalysisReport.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(AnalysisReport.getter(AnalysisReport::endTime)).setter(AnalysisReport.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AnalysisReport.getter(AnalysisReport::statusAsString)).setter(AnalysisReport.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<Insight>> INSIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Insights").getter(AnalysisReport.getter(AnalysisReport::insights)).setter(AnalysisReport.setter(Builder::insights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Insights").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Insight::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_REPORT_ID_FIELD, IDENTIFIER_FIELD, SERVICE_TYPE_FIELD, CREATE_TIME_FIELD, START_TIME_FIELD, END_TIME_FIELD, STATUS_FIELD, INSIGHTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AnalysisReport.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String analysisReportId;
    private final String identifier;
    private final String serviceType;
    private final Instant createTime;
    private final Instant startTime;
    private final Instant endTime;
    private final String status;
    private final List<Insight> insights;

    private AnalysisReport(BuilderImpl builder) {
        this.analysisReportId = builder.analysisReportId;
        this.identifier = builder.identifier;
        this.serviceType = builder.serviceType;
        this.createTime = builder.createTime;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.status = builder.status;
        this.insights = builder.insights;
    }

    public final String analysisReportId() {
        return this.analysisReportId;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final ServiceType serviceType() {
        return ServiceType.fromValue(this.serviceType);
    }

    public final String serviceTypeAsString() {
        return this.serviceType;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final AnalysisStatus status() {
        return AnalysisStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasInsights() {
        return this.insights != null && !(this.insights instanceof SdkAutoConstructList);
    }

    public final List<Insight> insights() {
        return this.insights;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisReportId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInsights() ? this.insights() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisReport)) {
            return false;
        }
        AnalysisReport other = (AnalysisReport)obj;
        return Objects.equals(this.analysisReportId(), other.analysisReportId()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.serviceTypeAsString(), other.serviceTypeAsString()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasInsights() == other.hasInsights() && Objects.equals(this.insights(), other.insights());
    }

    public final String toString() {
        return ToString.builder((String)"AnalysisReport").add("AnalysisReportId", (Object)this.analysisReportId()).add("Identifier", (Object)this.identifier()).add("ServiceType", (Object)this.serviceTypeAsString()).add("CreateTime", (Object)this.createTime()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Status", (Object)this.statusAsString()).add("Insights", this.hasInsights() ? this.insights() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnalysisReportId": {
                return Optional.ofNullable(clazz.cast(this.analysisReportId()));
            }
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "ServiceType": {
                return Optional.ofNullable(clazz.cast(this.serviceTypeAsString()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Insights": {
                return Optional.ofNullable(clazz.cast(this.insights()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AnalysisReportId", ANALYSIS_REPORT_ID_FIELD);
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("ServiceType", SERVICE_TYPE_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Insights", INSIGHTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalysisReport, T> g) {
        return obj -> g.apply((AnalysisReport)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String analysisReportId;
        private String identifier;
        private String serviceType;
        private Instant createTime;
        private Instant startTime;
        private Instant endTime;
        private String status;
        private List<Insight> insights = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisReport model) {
            this.analysisReportId(model.analysisReportId);
            this.identifier(model.identifier);
            this.serviceType(model.serviceType);
            this.createTime(model.createTime);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.status(model.status);
            this.insights(model.insights);
        }

        public final String getAnalysisReportId() {
            return this.analysisReportId;
        }

        public final void setAnalysisReportId(String analysisReportId) {
            this.analysisReportId = analysisReportId;
        }

        @Override
        public final Builder analysisReportId(String analysisReportId) {
            this.analysisReportId = analysisReportId;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getServiceType() {
            return this.serviceType;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        @Override
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Override
        public final Builder serviceType(ServiceType serviceType) {
            this.serviceType(serviceType == null ? null : serviceType.toString());
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AnalysisStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<Insight.Builder> getInsights() {
            List<Insight.Builder> result = InsightListCopier.copyToBuilder(this.insights);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInsights(Collection<Insight.BuilderImpl> insights) {
            this.insights = InsightListCopier.copyFromBuilder(insights);
        }

        @Override
        public final Builder insights(Collection<Insight> insights) {
            this.insights = InsightListCopier.copy(insights);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insights(Insight ... insights) {
            this.insights(Arrays.asList(insights));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insights(Consumer<Insight.Builder> ... insights) {
            this.insights(Stream.of(insights).map(c -> (Insight)((Insight.Builder)Insight.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AnalysisReport build() {
            return new AnalysisReport(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalysisReport> {
        public Builder analysisReportId(String var1);

        public Builder identifier(String var1);

        public Builder serviceType(String var1);

        public Builder serviceType(ServiceType var1);

        public Builder createTime(Instant var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder status(String var1);

        public Builder status(AnalysisStatus var1);

        public Builder insights(Collection<Insight> var1);

        public Builder insights(Insight ... var1);

        public Builder insights(Consumer<Insight.Builder> ... var1);
    }
}

