/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pi.PiClient;
import software.amazon.awssdk.services.pi.internal.UserAgentUtils;
import software.amazon.awssdk.services.pi.model.ListAvailableResourceDimensionsRequest;
import software.amazon.awssdk.services.pi.model.ListAvailableResourceDimensionsResponse;

public class ListAvailableResourceDimensionsIterable
implements SdkIterable<ListAvailableResourceDimensionsResponse> {
    private final PiClient client;
    private final ListAvailableResourceDimensionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAvailableResourceDimensionsIterable(PiClient client, ListAvailableResourceDimensionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAvailableResourceDimensionsResponseFetcher();
    }

    public Iterator<ListAvailableResourceDimensionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAvailableResourceDimensionsResponseFetcher
    implements SyncPageFetcher<ListAvailableResourceDimensionsResponse> {
        private ListAvailableResourceDimensionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAvailableResourceDimensionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAvailableResourceDimensionsResponse nextPage(ListAvailableResourceDimensionsResponse previousPage) {
            if (previousPage == null) {
                return ListAvailableResourceDimensionsIterable.this.client.listAvailableResourceDimensions(ListAvailableResourceDimensionsIterable.this.firstRequest);
            }
            return ListAvailableResourceDimensionsIterable.this.client.listAvailableResourceDimensions((ListAvailableResourceDimensionsRequest)((Object)ListAvailableResourceDimensionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

