/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pi.model.DimensionDetail;
import software.amazon.awssdk.services.pi.model.DimensionDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DimensionGroupDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DimensionGroupDetail> {
    private static final SdkField<String> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Group").getter(DimensionGroupDetail.getter(DimensionGroupDetail::group)).setter(DimensionGroupDetail.setter(Builder::group)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").build()}).build();
    private static final SdkField<List<DimensionDetail>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Dimensions").getter(DimensionGroupDetail.getter(DimensionGroupDetail::dimensions)).setter(DimensionGroupDetail.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DimensionDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_FIELD, DIMENSIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String group;
    private final List<DimensionDetail> dimensions;

    private DimensionGroupDetail(BuilderImpl builder) {
        this.group = builder.group;
        this.dimensions = builder.dimensions;
    }

    public final String group() {
        return this.group;
    }

    public final boolean hasDimensions() {
        return this.dimensions != null && !(this.dimensions instanceof SdkAutoConstructList);
    }

    public final List<DimensionDetail> dimensions() {
        return this.dimensions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensions() ? this.dimensions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimensionGroupDetail)) {
            return false;
        }
        DimensionGroupDetail other = (DimensionGroupDetail)obj;
        return Objects.equals(this.group(), other.group()) && this.hasDimensions() == other.hasDimensions() && Objects.equals(this.dimensions(), other.dimensions());
    }

    public final String toString() {
        return ToString.builder((String)"DimensionGroupDetail").add("Group", (Object)this.group()).add("Dimensions", this.hasDimensions() ? this.dimensions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DimensionGroupDetail, T> g) {
        return obj -> g.apply((DimensionGroupDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String group;
        private List<DimensionDetail> dimensions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DimensionGroupDetail model) {
            this.group(model.group);
            this.dimensions(model.dimensions);
        }

        public final String getGroup() {
            return this.group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final List<DimensionDetail.Builder> getDimensions() {
            List<DimensionDetail.Builder> result = DimensionDetailListCopier.copyToBuilder(this.dimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensions(Collection<DimensionDetail.BuilderImpl> dimensions) {
            this.dimensions = DimensionDetailListCopier.copyFromBuilder(dimensions);
        }

        @Override
        public final Builder dimensions(Collection<DimensionDetail> dimensions) {
            this.dimensions = DimensionDetailListCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(DimensionDetail ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<DimensionDetail.Builder> ... dimensions) {
            this.dimensions(Stream.of(dimensions).map(c -> (DimensionDetail)((DimensionDetail.Builder)DimensionDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DimensionGroupDetail build() {
            return new DimensionGroupDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DimensionGroupDetail> {
        public Builder group(String var1);

        public Builder dimensions(Collection<DimensionDetail> var1);

        public Builder dimensions(DimensionDetail ... var1);

        public Builder dimensions(Consumer<DimensionDetail.Builder> ... var1);
    }
}

