/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalizeruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.personalizeruntime.model.FilterValuesCopier;
import software.amazon.awssdk.services.personalizeruntime.model.PersonalizeRuntimeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetActionRecommendationsRequest
extends PersonalizeRuntimeRequest
implements ToCopyableBuilder<Builder, GetActionRecommendationsRequest> {
    private static final SdkField<String> CAMPAIGN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("campaignArn").getter(GetActionRecommendationsRequest.getter(GetActionRecommendationsRequest::campaignArn)).setter(GetActionRecommendationsRequest.setter(Builder::campaignArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("campaignArn").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(GetActionRecommendationsRequest.getter(GetActionRecommendationsRequest::userId)).setter(GetActionRecommendationsRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final SdkField<Integer> NUM_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numResults").getter(GetActionRecommendationsRequest.getter(GetActionRecommendationsRequest::numResults)).setter(GetActionRecommendationsRequest.setter(Builder::numResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numResults").build()}).build();
    private static final SdkField<String> FILTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterArn").getter(GetActionRecommendationsRequest.getter(GetActionRecommendationsRequest::filterArn)).setter(GetActionRecommendationsRequest.setter(Builder::filterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterArn").build()}).build();
    private static final SdkField<Map<String, String>> FILTER_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("filterValues").getter(GetActionRecommendationsRequest.getter(GetActionRecommendationsRequest::filterValues)).setter(GetActionRecommendationsRequest.setter(Builder::filterValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterValues").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_ARN_FIELD, USER_ID_FIELD, NUM_RESULTS_FIELD, FILTER_ARN_FIELD, FILTER_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("campaignArn", CAMPAIGN_ARN_FIELD);
            this.put("userId", USER_ID_FIELD);
            this.put("numResults", NUM_RESULTS_FIELD);
            this.put("filterArn", FILTER_ARN_FIELD);
            this.put("filterValues", FILTER_VALUES_FIELD);
        }
    });
    private final String campaignArn;
    private final String userId;
    private final Integer numResults;
    private final String filterArn;
    private final Map<String, String> filterValues;

    private GetActionRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.campaignArn = builder.campaignArn;
        this.userId = builder.userId;
        this.numResults = builder.numResults;
        this.filterArn = builder.filterArn;
        this.filterValues = builder.filterValues;
    }

    public final String campaignArn() {
        return this.campaignArn;
    }

    public final String userId() {
        return this.userId;
    }

    public final Integer numResults() {
        return this.numResults;
    }

    public final String filterArn() {
        return this.filterArn;
    }

    public final boolean hasFilterValues() {
        return this.filterValues != null && !(this.filterValues instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> filterValues() {
        return this.filterValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.campaignArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.numResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterValues() ? this.filterValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetActionRecommendationsRequest)) {
            return false;
        }
        GetActionRecommendationsRequest other = (GetActionRecommendationsRequest)((Object)obj);
        return Objects.equals(this.campaignArn(), other.campaignArn()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.numResults(), other.numResults()) && Objects.equals(this.filterArn(), other.filterArn()) && this.hasFilterValues() == other.hasFilterValues() && Objects.equals(this.filterValues(), other.filterValues());
    }

    public final String toString() {
        return ToString.builder((String)"GetActionRecommendationsRequest").add("CampaignArn", (Object)this.campaignArn()).add("UserId", (Object)this.userId()).add("NumResults", (Object)this.numResults()).add("FilterArn", (Object)this.filterArn()).add("FilterValues", (Object)(this.filterValues() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "campaignArn": {
                return Optional.ofNullable(clazz.cast(this.campaignArn()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "numResults": {
                return Optional.ofNullable(clazz.cast(this.numResults()));
            }
            case "filterArn": {
                return Optional.ofNullable(clazz.cast(this.filterArn()));
            }
            case "filterValues": {
                return Optional.ofNullable(clazz.cast(this.filterValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetActionRecommendationsRequest, T> g) {
        return obj -> g.apply((GetActionRecommendationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeRuntimeRequest.BuilderImpl
    implements Builder {
        private String campaignArn;
        private String userId;
        private Integer numResults;
        private String filterArn;
        private Map<String, String> filterValues = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetActionRecommendationsRequest model) {
            super(model);
            this.campaignArn(model.campaignArn);
            this.userId(model.userId);
            this.numResults(model.numResults);
            this.filterArn(model.filterArn);
            this.filterValues(model.filterValues);
        }

        public final String getCampaignArn() {
            return this.campaignArn;
        }

        public final void setCampaignArn(String campaignArn) {
            this.campaignArn = campaignArn;
        }

        @Override
        public final Builder campaignArn(String campaignArn) {
            this.campaignArn = campaignArn;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final Integer getNumResults() {
            return this.numResults;
        }

        public final void setNumResults(Integer numResults) {
            this.numResults = numResults;
        }

        @Override
        public final Builder numResults(Integer numResults) {
            this.numResults = numResults;
            return this;
        }

        public final String getFilterArn() {
            return this.filterArn;
        }

        public final void setFilterArn(String filterArn) {
            this.filterArn = filterArn;
        }

        @Override
        public final Builder filterArn(String filterArn) {
            this.filterArn = filterArn;
            return this;
        }

        public final Map<String, String> getFilterValues() {
            if (this.filterValues instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.filterValues;
        }

        public final void setFilterValues(Map<String, String> filterValues) {
            this.filterValues = FilterValuesCopier.copy(filterValues);
        }

        @Override
        public final Builder filterValues(Map<String, String> filterValues) {
            this.filterValues = FilterValuesCopier.copy(filterValues);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetActionRecommendationsRequest build() {
            return new GetActionRecommendationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PersonalizeRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetActionRecommendationsRequest> {
        public Builder campaignArn(String var1);

        public Builder userId(String var1);

        public Builder numResults(Integer var1);

        public Builder filterArn(String var1);

        public Builder filterValues(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

