/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalizeruntime;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.personalizeruntime.DefaultPersonalizeRuntimeAsyncClient;
import software.amazon.awssdk.services.personalizeruntime.DefaultPersonalizeRuntimeBaseClientBuilder;
import software.amazon.awssdk.services.personalizeruntime.PersonalizeRuntimeAsyncClient;
import software.amazon.awssdk.services.personalizeruntime.PersonalizeRuntimeAsyncClientBuilder;
import software.amazon.awssdk.services.personalizeruntime.PersonalizeRuntimeServiceClientConfiguration;
import software.amazon.awssdk.services.personalizeruntime.endpoints.PersonalizeRuntimeEndpointProvider;

@SdkInternalApi
final class DefaultPersonalizeRuntimeAsyncClientBuilder
extends DefaultPersonalizeRuntimeBaseClientBuilder<PersonalizeRuntimeAsyncClientBuilder, PersonalizeRuntimeAsyncClient>
implements PersonalizeRuntimeAsyncClientBuilder {
    DefaultPersonalizeRuntimeAsyncClientBuilder() {
    }

    @Override
    public DefaultPersonalizeRuntimeAsyncClientBuilder endpointProvider(PersonalizeRuntimeEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final PersonalizeRuntimeAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultPersonalizeRuntimeAsyncClientBuilder.validateClientOptions(clientConfiguration);
        PersonalizeRuntimeServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultPersonalizeRuntimeAsyncClient client = new DefaultPersonalizeRuntimeAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private PersonalizeRuntimeServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return PersonalizeRuntimeServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

